-----------------------------------------
-- Create Date:    22:52:45 06/15/2015 
-- Module Name:    system - Behavioral 
-----------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity system is
port(
   clk : IN STD_LOGIC;
   clr : IN STD_LOGIC;
   start : IN STD_LOGIC;
   pos : IN STD_LOGIC_VECTOR( 6 downto 0 );
   servo : OUT STD_LOGIC;
   trig : OUT STD_LOGIC;
   echo : IN STD_LOGIC;
   distance : OUT STD_LOGIC_VECTOR( 7 downto 0 );
   valid : OUT STD_LOGIC );
end system;

architecture system_arch of system is

   component clock_divider is
   port ( 
      clk : in  STD_LOGIC;
      clr : in  STD_LOGIC;
      enable : out  STD_LOGIC);
   end component;
   
   component servo_control is
   port(
      clk : IN  STD_LOGIC;
      clr : IN  STD_LOGIC;
      ce  : IN  STD_LOGIC;
      pos : IN  STD_LOGIC_VECTOR(6 downto 0);
      servo : OUT STD_LOGIC );
   end component;
   
   component sensor is
   Port ( 
      clk      : in  STD_LOGIC;
      clr      : in  STD_LOGIC;
      ce       : in  STD_LOGIC;
      start      : in  STD_LOGIC;
      echo     : in  STD_LOGIC;
      trig     : out STD_LOGIC;           
      distance : out STD_LOGIC_VECTOR (7 downto 0);
      valid    : out STD_LOGIC );
   end component;
   
   signal enable : STD_LOGIC;   
   
   signal servo_int : STD_LOGIC;   
   signal trig_int : STD_LOGIC;   
   signal echo_int : STD_LOGIC;   
   
begin

   servo <= not servo_int;
   trig <= not trig_int;
   echo_int <= not echo;
   
   clock_div: clock_divider port map( 
      clk    => clk,
      clr    => clr,
      enable => enable );
   
   servo_ctl: servo_control port map(
      clk   => clk,
      clr   => clr,
      ce    => enable,
      pos   => pos,
      servo => servo_int );

   ultrsonic: sensor port map( 
      clk      => clk,
      clr      => clr,
      ce       => enable,
      start    => start,
      echo     => echo_int,
      trig     => trig_int,     
      distance => distance,
      valid    => valid );

end system_arch;

