--------------------------------------------------------------------------------
-- Create Date:   10:40:16 06/16/2015
-- Module Name:   /home/mike/Documents/Lectures/PROM/Exam/Servo/system_tb.vhd
-- Project Name:  Servo
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
ENTITY system_tb IS
END system_tb;
 
ARCHITECTURE behavior OF system_tb IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT system
    PORT(
         clk : IN  std_logic;
         clr : IN  std_logic;
         start : IN  std_logic;
         pos : IN  std_logic_vector(6 downto 0);
         servo : OUT  std_logic;
         trig : OUT  std_logic;
         echo : IN  std_logic;
         distance : OUT  std_logic_vector(7 downto 0);
         valid : OUT  std_logic
        );
    END COMPONENT;
    

   --Inputs
   signal clk : std_logic := '0';
   signal clr : std_logic := '0';
   signal start : std_logic := '0';
   signal pos : std_logic_vector(6 downto 0) := (others => '0');
   signal echo : std_logic := '0';

 	--Outputs
   signal servo : std_logic;
   signal trig : std_logic;
   signal distance : std_logic_vector(7 downto 0);
   signal valid : std_logic;

   -- Clock period definitions
   constant clk_period : time := 250 ns;
 
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: system PORT MAP (
          clk => clk,
          clr => clr,
          start => start,
          pos => pos,
          servo => servo,
          trig => trig,
          echo => echo,
          distance => distance,
          valid => valid
        );

   -- Clock process definitions
   clk_process :process
   begin
		clk <= '0';
		wait for clk_period/2;
		clk <= '1';
		wait for clk_period/2;
   end process;
 
   -- Clear process definitions
   clr_process :process
   begin
		clr <= '1';
		wait for clk_period * 10;
		clr <= '0';
		wait;
   end process;
	
   -- Stimulus process
   stim_proc: process
   begin		
		start <= '0';
      pos <= (others => '0');
		echo <= '1';
		wait for clk_period * 15;	

		start <= '1';
		wait for clk_period * 10;	
		start <= '0';
		wait for clk_period * 10;	

		wait for 300 us;
		echo <= '0';	
		wait for 1.2 ms;
		echo <= '1';
		
		wait for 2 ms;
		pos <= "0000001";
		wait for 40 ms;
		pos <= "0000010";		
		wait for 40 ms;
		pos <= "0000100";
		wait for 40 ms;
		pos <= "0001000";	
		wait for 40 ms;
		pos <= "0010000";
		wait for 40 ms;
		pos <= "0100000";	
		wait for 40 ms;
		pos <= "1000000";	
		wait for 40 ms;
		pos <= "1111111";			
      wait;
   end process;

END;
