/*
 * NoC_lib_V5.h
 *
 *  Created on: 31 Jan 2017
 *      Author: mr589
 */

#ifndef NOC_LIB_V5_H_
#define NOC_LIB_V5_H_

/*
 * NoC_lib_V5.c
 *
 *  Created on: 31 Jan 2017
 *      Author: mr589
 */

#include "xbasic_types.h"

#define NOC_WIDTH 3
#define NOC_HEIGHT 4

void NoC_write_blocking(Xuint32 data);

//broadcast the reset signal to all nodes
void NoC_reset();

//writes a word (1bit control + 8 bits data) to the NoC
//Will wait until interface is ready before sending
void NoC_write_blocking(Xuint32 data);

//reads a word (1bit control + 8 bits data) from the NoC
//Will wait until data is available
Xuint32 NoC_read_blocking();

//writes a word (1bit control + 8 bits data) to the NoC
//returns a 1 if write was successful, 0 otherwise
Xuint32 NoC_write_non_blocking(Xuint32 data);

//reads a word (1bit control + 8 bits data) from the NoC
//returns a 1 if read was succesfull and data is valid, 0 otherwise
Xuint32 NoC_read_non_blocking(Xuint32 *data);


void NoC_Write_Sys_Packet(int node, Xuint8* data, int length, int header);

//assign the IDs to all nodes - the nodes use this to send stuff
//back to the Microblaze so don't forget to to it at the start!
void NoC_Assign_Node_IDs();


//Broadcast a single command (no data) to all nodes
void NoC_Broadcast_Command(Xuint32 command);

#endif /* NOC_LIB_V5_H_ */
