/*
 * applications.h
 *
 *  Created on: 28 Mar 2017
 *      Author: jf878
 *
 *      Contains data structures and function
 *      prototypes related to applications
 *
 */

#ifndef APPLICATIONS_H_
#define APPLICATIONS_H_

#include "xbasic_types.h"

/* Define bits in the requirements field */
#define MEMORY_ACCESS 	0
#define FPU 			1
#define VECTOR_UNIT		2
#define HIGH_BW_BUS 	3
#define HOST_ACCESS 	4
#define IO_ACCESS 		5
/* Used as other markers, see names */
#define IS_PARALLELIZABLE 	6
#define FUTURE_USE2 	7
#define TASK_SIZE 13


/* Struct representing a task */
typedef struct {
        Xuint8 requirements;
        Xuint32 priority;
        Xuint32 parentApplication; // Pointer to/ID of parent application
        Xuint32 taskTime; // How long will the task be active
        // Can be extended for further details
} task_t;



typedef struct {
        Xuint32 priority;
        Xuint32 numberOfTasks;
        Xuint32 tasksPointer;
        task_t * taskList;
} application_t;


/* Generate a list of tasks with random characteristics */
void generate_null_tasks(task_t * taskList, Xuint32 numberOfTasks, application_t * parentApplication);

/* Create an application of null tasks */
void generate_null_application(application_t * application, Xuint32 numberOfTasks, task_t * taskMemory, Xuint8 priority);


#endif /* APPLICATIONS_H_ */
