/*
 * main.c
 *
 *  Created on: 26 Jan 2017
 *      Author: mr589
 */
#include "NoC_lib_V5.h"
#include "xil_printf.h"
//#include "rtc.h"

int main()
{

	/* Enable the cache */
	microblaze_enable_dcache();
	microblaze_enable_icache();

	xil_printf("V5 Many-Core Test \r\n");
	NoC_reset();

	NoC_Assign_Node_IDs(); // Assign the nodes IDs

	RTC_Set_Prescaler(100-1); // Set the prescaler to 99 (F=1MHz)

	/* Read and store the current TRC time */
	Xuint32 startTime = RTC_Read_Value();
	xil_printf("RTC: %d\r\n", startTime);

	/* Lets start by sending some data to a specific node */
	int dataLength = 1;
	int sendToNode = 6;
	Xuint8 data;

	data = (Xuint8)RTC_Read_Value();
	xil_printf("Data Sent %d \r\n", data);

	NoC_Write_Sys_Packet(sendToNode, &data, dataLength, 0);

	data = NoC_read_blocking();

	xil_printf("Returned from node: %d \r\n", data);

	while(1);
}
