/*
 * rtc.c
 *
 *  Created on: 7 Feb 2017
 *      Author: mr589
 */


#include "xparameters.h"
#include "rtc.h"

#define RTC_BASE (Xuint32*)XPAR_RTC_0_BASEADDR
#define RTC_PRESCALER_REG (Xuint32*)(XPAR_RTC_0_BASEADDR + 0x04)

static Xuint32 prescaler_value;


//The RTC clock runs at 100MHz, so we have to divide that down
//to get anything of use. This is the job of the prescaler.
//(one RTC tick is one full count of the prescaler at 100MHZ)

//N.B. this counts from the value THROUGH zero, so minus 1 from
//the value to be accurate.
//For example, to get a 200ns RTC tick, set the prescaler value to 19
void RTC_Set_Prescaler(Xuint32 value)
{
	prescaler_value = value;
	*RTC_PRESCALER_REG = prescaler_value;
}

//when the prescaler is written to it resets the RTC. Thus to reset it
//we can just rewrite the prescaler value.
void RTC_Reset_RTC()
{
	*RTC_PRESCALER_REG = prescaler_value;
}

//The RTC value is a global signal to all the nodes, but also in a reg so the V5 can read it
Xuint32 RTC_Read_Value()
{
	return *RTC_BASE;
}
