/*
 * rtc.h
 *
 *  Created on: 7 Feb 2017
 *      Author: mr589
 */

#ifndef RTC_H_
#define RTC_H_

#include "xbasic_types.h"

//The RTC clock runs at 100MHz, so we have to divide that down
//to get anything of use. This is the job of the prescaler.
//(one RTC tick is one full count of the prescaler at 100MHZ)

//N.B. this counts from the value THROUGH zero, so minus 1 from
//the value to be accurate.
//For example, to get a 200ns RTC tick, set the prescaler value to 19
void RTC_Set_Prescaler(Xuint32 value);

//when the prescaler is written to it resets the RTC. Thus to reset it
//we can just rewrite the prescaler value.
void RTC_Reset_RTC();


//The RTC value is a global signal to all the nodes, but also in a reg so the V5 can read it
Xuint32 RTC_Read_Value();

#endif /* RTC_H_ */
