/*
 * core.h
 *
 *  Created on: 24 Mar 2017
 *      Author: jf878
 *
 *  Contains info on the core as well as
 *  prototypes for functions that can
 *  access and alter this information
 *
 */

#ifndef CORE_H_
#define CORE_H_

#include "xbasic_types.h"
#include "task.h"
#include "NoC_lib.h"
#include "epidemic_model.h"

/* Define bits in the resources field */
#define MEMORY_ACCESS 	(1 << 0)
#define FPU 			(1 << 1)
#define VECTOR_UNIT		(1 << 2)
#define HIGH_BW_BUS 	(1 << 3)
#define HOST_ACCESS 	(1 << 4)
#define IO_ACCESS 		(1 << 5)
/* Possibly to be used as markers similar to those in task */
#define NEW_INFECTION 	(1 << 6) // Set if a new app is going to take over when the current task finishes
#define IS_HOT		 	(1 << 7)

/* Definition core */
typedef struct {
	Xuint8 node_id;
	Xuint8 Treject;
	Xuint8 Taccept;
	Xuint8 Tcritical;
	Xuint8 Tcurrent;
	Xuint8 resources;
	task_t * currentTask;
	task_t * infectingTask;
} core_t;

core_t core;

/* Initialise a core */
void init_core(core_t * core, Xuint8 core_ID);

/* Increase the temp if there is a task running, decrease if not */
void update_temperature();

/* Check the NoC for infecting tasks and its conditions
 * returns a 1 if task infects, 0 otherwise */
Xuint8 check_infection(task_t taskToCheck);

/* Change from one task (or none) to a new task */
Xuint8 change_task();

#endif /* CORE_H_ */
