/*
 * epidemic_model.c
 *
 *  Created on: 28 Mar 2017
 *      Author: jf878
 */

#include "epidemic_model.h"

/* Uses the RTC to create a pseudo-random number */
Xuint32 rand_from_RTC(Xuint32 range) {
	return Read_RTC() % range;
}

/* Coin flip weighted towards being 1 */
Xuint8 weighted_coinflip(Xuint8 weight) {

	/* Choose a random number, if not zero then return a 1 */
	if (Read_RTC() % (weight + 1)) {
		return 1;
	}

	/* If the number was 0 then return 0 */
	return 0;
}

/* Attempts to infect all neighbours one at a time */
Xuint8 infect_neighbour(task_t * task) {

	Xuint8 infect = INFECTION_PACKET;
	Xuint8 random = rand_from_RTC(4);
	Xuint8 success = 0;
	Xuint32 startTime;

	Xuint8 i;
	for (i = 0; i < 4; i++) {

		random = (random + 1) % 4;

		/* Choose the next neighbour and send INFECTION_PACKET */
		NoC_Send_To_Neighbour(random, &infect, 1);

		/* Send a message containing a task requirements, parent ID, and priority. */
		NoC_Send_To_Neighbour(random, (Xuint8 *)(task), TASK_SIZE);

		/* Start the timeout timer */
		startTime = Read_RTC();

		/* Wait for a confirmation or a timeout */
		Xuint8 msg_received = 0;
		while (!msg_received) {

			/* Check the input and get it if there is something */
			msg_received = NoC_Recieve_Packet_Non_Blocking(&success, 1);

			if (success) {
				/* If successful infection */
				return 1;
			}

			// Check the timeout
			if ((Read_RTC() - startTime) >  TIME_LIMIT) {
				/* Send a "TIMED_OUT" packet */
				Xuint8 timedOut = TIMED_OUT;
				NoC_Send_To_Neighbour(random, &timedOut, 1);
				msg_received = 1; // set this to break out of the loop
			}

		}

	}
	return 0;
}

/* Attempts to infect a random core in the array */
Xuint8 infect_random(task_t * task) {

	Xuint8 infect = INFECTION_PACKET;
	Xuint8 success = 0;
	Xuint32 startTime;

	/* Choose a random node */
	Xuint32 random = rand_from_RTC(NOC_WIDTH * NOC_HEIGHT);

	/* Choose the next neighbour and send INFECTION_PACKET */
	NoC_Write_Node_Packet(random, &infect, 1, 0);

	/* Send a message containing a task requirements, parent ID, and priority. */
	NoC_Write_Node_Packet(random, (Xuint8 *)(task), TASK_SIZE, 0);

	/* Start the timeout timer */
	startTime = Read_RTC();

	/* Wait for a confirmation or a timeout */
	Xuint8 msg_received = 0;
	while (!msg_received) {

		/* Check the input and get it if there is something, need to get the second byte so do this twice */
		msg_received = NoC_Recieve_Packet_Non_Blocking(&success, 1);
		msg_received = NoC_Recieve_Packet_Non_Blocking(&success, 1); // I don't like this

		if (success) {
			/* If successful infection */
			return 1;
		}

		// Check the timeout
		if ((Read_RTC() - startTime) >  TIME_LIMIT) {
			/* Send a "TIMED_OUT" packet */
			Xuint8 timedOut = TIMED_OUT;
			NoC_Write_Node_Packet(random, &timedOut, 1, 0);
			msg_received = 1; // set this to break out of the loop
		}

	}

	return 0;
}

/* Report info back to the host */
void report_to_host(task_t task, Xuint8 reportType) {

	int dataLength = 10;
	Xuint8 data[dataLength];

	/* Tell the host this is a report, of what type, and from where */
	data[0] = REPORT;
	data[1] = reportType;
	data[2] = node_id;

	/* Send the data */
	NoC_Write_Sys_Packet(&data[0], dataLength);

}
