
#include "NoC_lib.h"
#include "core.h"
#include "task.h"


//TODO: Stop the parallel tasks from constantly spreading.


Xuint8 is_infected = 0;

Xuint32 save_me __attribute__ ((section (".noinit")));

int main()
{
	/* First, initialise the NoC */
	NoC_Init();

	/* Create a handle to the core and initialise the core attributes */
	init_core(&core, NoC_Read_Byte_Blocking());
	//read EOP after getting the ID
	NoC_Send_ACK();

	/* Print confirmation and ID to the UART */
	xil_printf("Node %d is up and running\r\n", core.node_id);

	/*******************************************************/
	/***  Now we're setup lets do something on the core  ***/
	/*******************************************************/

	/* Variable declarations */
	Xuint32 time;
	Xuint8 data[10];
	Xuint32 length;

	/* Read and print the RTC */
	xil_printf("RTC_value: %d\r\n", Read_RTC());


	/**********************************/
	/*****  Main processing loop  *****/
	/**********************************/
	while(1) {

		/* while not infected */
		while(!is_infected) {

			xil_printf("Core Free");

			/* Get RTC time */
			time = Read_RTC();

			/* Wait for infection attempt */
			length = NoC_Read_Blocking(); // Get the length of the incoming packet
			NoC_Recieve_Packet_Blocking(&data[0], (int)length); //Get the data from the RX buffer
			NoC_Send_ACK(); // ACK the packet

			/* Update the temperature and check infecting task */
			update_temperature(Read_RTC() - time);

			if (data[1] == INFECTION_PACKET) {
				/* Get the information about the infecting task */
				NoC_Recieve_Packet_Blocking((Xuint8 *)(&infectingTask), TASK_SIZE);
				is_infected = check_infection( infectingTask );
			}

			/* No need to check timeout here as we respond right away */

			/* Respond to the core that infected */
			if ((is_infected) && (data[0] != 0xFF)) {
				Xuint8 accept = ACCEPT_INFECTION;
				NoC_Write_Node_Packet(data[0], &accept, 1, 0); //node, data, length, header
				report_to_host(infectingTask, INFECTION_SPREAD);
				core.infectingTask = &infectingTask;

				/* If the command comes from the host, always accept */
			} else if (data[0] == 0xFF) {
				core.infectingTask = &infectingTask;
			}

			time = Read_RTC();
		}
		/* If we leave this loop then the core is infected */


		while (change_task()) {
			xil_printf("Core infected");



			/* IS the current task parallelizable? */
			if (core.currentTask->requirements & IS_PARALLELIZABLE) {

				// Attempt to infect neighbours
				if (!infect_neighbour(core.currentTask)) {
					// if not successful then attempt to infect random core
					infect_random(core.currentTask);
				}
			}



			/***************************************************/
			/*****  Where the core would process its task  *****/
			/***************************************************/

			Xuint32 taskTimer = Read_RTC();
			Xuint32 deltaT = 0;

			while (currentTask.taskTime > deltaT) {
				deltaT = Read_RTC() - taskTimer;
			}


			/* Tell the host when we finish a task */
			report_to_host(currentTask, TASK_FINISHED);

			/* Now check that no new task is trying to infect */
			if (NoC_Recieve_Packet_Non_Blocking(&data[0], 2)) { //Get the data from the RX buffer
				NoC_Send_ACK(); // ACK the packet
				if (data[1] == INFECTION_PACKET) {
					/* Get the information about the infecting task */
					 NoC_Recieve_Packet_Blocking((Xuint8 *)(&infectingTask), TASK_SIZE);
					is_infected = check_infection( infectingTask );
				}

				/* Check the other core didn't time out */
				NoC_Recieve_Packet_Non_Blocking(&data[0], 1);
				NoC_Send_ACK();
				if (data[1] == TIMED_OUT) {
					is_infected = 0;

				/* Let the other core know if the infection was successful */
				} else if (is_infected) {
					Xuint8 accept = ACCEPT_INFECTION;
					NoC_Write_Node_Packet(data[0], &accept, 1, 0);
					report_to_host(infectingTask, INFECTION_SPREAD);
					core.infectingTask = &infectingTask;
				}
			}
		}

		/* Clear the is_infection var and go back to the start of the main loop */
		is_infected = 0;

	}
}
