/*
 * applications.c
 *
 *  Created on: 28 Mar 2017
 *      Author: jf878
 *
 *      File contains data structures and functions
 *      relating to applications and tasks
 *
 */

#include "applications.h"

/* Generate a list of tasks with random characteristics */
void generate_null_tasks(task_t * taskList, Xuint32 numberOfTasks, application_t * parentApplication) {

	int i;
	for (i = 0; i < numberOfTasks; i++) {

		taskList[i].parentApplication = (Xuint32)parentApplication;
		taskList[i].priority = parentApplication->priority;
		taskList[i].requirements = (Xuint8)(rand() & 0xFF); // Generate random requirements for the task

		taskList[i].taskTime = rand();

	}
}

/* Create an application of null tasks */
void generate_null_application(application_t * application, Xuint32 numberOfTasks, task_t * taskMemory, Xuint8 priority) {
									/* pointer to an application, number of tasks, pointer to an array of tasks, priority */

	generate_null_tasks(taskMemory, numberOfTasks, application);
	application->priority = priority;

}
