#ifndef NOC_LIB_H_
#define NOC_LIB_H_

#include "xbasic_types.h"
#include "task.h"

#define NOC_WIDTH 3
#define NOC_HEIGHT 4

extern Xuint8 node_id;

void NoC_Init();

void NoC_Init();

void ACK_RX();

//Thanks to the ECC bit in the Virtex BRAMs, we have a 9-bit fifo buffer for
//sending/recieving with the NoC


#include "NoC_lib.h"

#define TX_BUFF_SIZE 1024
#define TX_BUFF ((volatile unsigned int*)(0xC1000000))
#define RX_BUFF ((volatile unsigned int*)(0xC1000000 + (4*TX_BUFF_SIZE)))
#define NOC_CNTRL_IF (volatile unsigned int*)(0xC0000000)
#define NOC_STATUS_IF (volatile unsigned int*)(0xC0000004)
#define NOC_TX_LEN_IF (volatile unsigned int*)(0xC0000008)
#define NOC_RX_LEN_IF (volatile unsigned int*)(0xC000000C)
#define NOC_RX_BASE_IF (volatile unsigned int*)(0xC0000010)

#define RTC_GPI_ADDR (volatile Xuint32*)0x80000020

Xuint8 node_id;

/* Divide the RTC by this to get sysTicks; this is somewhat arbitrary */
#define SYSTICK 100

//clear the control reg and set the TX/RX buffer divide at half way
void NoC_Init();

//Thanks to the ECC bit in the Virtex BRAMs, we have a 9-bit fifo buffer for
//sending/recieving with the NoC
Xuint32 NoC_Read_Blocking();
//reads a token/word - i.e. a 9-bit chunk of data from the network
Xuint32 NoC_Read_Token_Blocking();

//reads a byte - i.e. an 8-bit chunk of data from the network
Xuint8 NoC_Read_Byte_Blocking();

//reads an int - i.e. an 32-bit chunk of data from the network and treats it as an int
Xuint32 NoC_Read_Int_Blocking();

//reads a token in a non blocking way.
//Returns 0 if there is no data available, or 1 if there is a token via the data pointer
Xuint32 NoC_Read_Token_Non_Blocking(Xuint32 *data);

/* Moves a number of bytes of data from the RX buffer,	*
 * if the RX buffer is empty then returns 0				*/
Xuint8 NoC_Recieve_Packet_Non_Blocking(Xuint8 *data, Xuint32 max_packet_length);

//sends a packet to the host microblaze node
void NoC_Write_Sys_Packet(Xuint8* data, int length);
//sends a packet to a neighbouring node
void NoC_Write_Node_Packet(int node, Xuint8* data, int length, Xuint32 header);

void NoC_Send_To_Neighbour(Xuint8 neighbour, Xuint8* data, int length);

//Recieve a node-to-node packet. NEEDS FINISHING!
void NoC_Recieve_Packet_Blocking(Xuint8 *data, int max_packet_length);

void NoC_Send_ACK();

void NoC_Dump_RX_Buff(int num_words);

void unpack_int(Xuint32* data, Xuint32* buff);

Xuint32 Read_RTC();

#endif /* NOC_LIB_H_ */
