/*
 * epidemic_model.h
 *
 *  Created on: 28 Mar 2017
 *      Author: jf878
 *
 *      Contains function prototypes for the epidemic model
 *
 */

#ifndef EPIDEMIC_MODEL_H_
#define EPIDEMIC_MODEL_H_

#include "xbasic_types.h"
#include "NoC_lib.h"
#include "task.h"

#define INFECTION_PACKET 	0x1F
#define ACCEPT_INFECTION	0x11
#define REJET_INFECTION		0x10
#define TIMED_OUT			0x12

/* Used for sending reports to host node */
#define REPORT				0xF0
#define NEXT_TASK_REQUEST	0xF1
#define TASK_FINISHED		0xF2
#define INFECTION_SPREAD	0XF3


#define TIME_LIMIT			5000 // 50 systicks

/* Uses the RTC to create a pseudo-random number */
Xuint32 rand_from_RTC(Xuint32 range);

/* Generates pseudo-random 1 or 0 from RTC */
#define coinFlip rand_from_RTC(1)

/* Coin flip weighted towards being true */
Xuint8 weighted_coinflip(Xuint8 weight);

/*****************************************************/
/*  Functions to infect other cores with a new task  */
/*****************************************************/

/* Attempts to infect all neighbours one at a time */
Xuint8 infect_neighbour(task_t * task);

/* Attempts to infect a random core in the array */
Xuint8 infect_random(task_t * task);


/* Reports info about the system back to the host */
void report_to_host(task_t task, Xuint8 reportType);

#endif /* EPIDEMIC_MODEL_H_ */
