#ifndef TASK_H_
#define TASK_H_

/*
 * Contains data structure for tasks and 	 *
 * prototypes for any task related functions */

#include "xbasic_types.h"

/* Define bits in the requirements field */
#define MEMORY_ACCESS 	(1 << 0)
#define FPU 			(1 << 1)
#define VECTOR_UNIT		(1 << 2)
#define HIGH_BW_BUS 	(1 << 3)
#define HOST_ACCESS 	(1 << 4)
#define IO_ACCESS 		(1 << 5)
/* Used as other markers, see names */
#define IS_PARALLELIZABLE 	(1 << 6)
#define FUTURE_USE2 		(1 << 7)


/* Struct representing a task */
typedef struct {
	Xuint8 requirements;
	Xuint32 priority;
	Xuint32 parentApplication; // Pointer to/ID of parent application
	Xuint32 taskTime; // How long will the task be active
	// Can be extended for further details
} task_t;

#define TASK_SIZE 13

/* Assign some memory for task structs */
task_t currentTask;
task_t infectingTask;

#endif
