import getopt

from brian2 import *
import sys
import csv

start_scope()
Config_Filename = sys.argv[1]

if Config_Filename == '2x2_Grid.txt':
    stimulus_indices = '2_bit_stimulus_indices.txt'
    stimulus_times = '2_bit_stimulus_times.txt'
    Run_Duration = 500 * ms
else:
    stimulus_indices = '8_bit_stimulus_indices.txt'
    stimulus_times = '8_bit_stimulus_times.txt'
    Run_Duration = 50750 * ms

try:
    options, optional_arguments = getopt.getopt(sys.argv[2:], "d:p:", ["duration =", "plots ="])
except:
    print('no optional parameters')

Plot_Type = 'simple'

for name, value in options:
    if name in ['-d', '--duration']:
        Run_Duration = int(value)*ms
        if Config_Filename == '2x2_Grid.txt' and Run_Duration > 500*ms:
            print('runtime cannot exceed length of stimulus, using default')
            Run_Duration = 500*ms
        elif Run_Duration > 50750*ms:
            print('runtime cannot exceed length of stimulus, using default')
            Run_Duration = 50750*ms
    elif name in ['-p', '--plots']:
        Plot_Type = value

Microcircuit_Config = []
with open(Config_Filename, newline='') as csv_file:
    csv_reader = csv.reader(csv_file, delimiter=',')
    for row in csv_reader:
        Microcircuit_Config.append(row)

Numb_Inputs = int(Microcircuit_Config[0][0])
print(Numb_Inputs)

Numb_Neurons = int(Microcircuit_Config[1][0])
print(Numb_Neurons)

Numb_Outputs = int(Microcircuit_Config[2][0])
print(Numb_Outputs)

Input_Connections = []
for x in range(0, Numb_Inputs):
    Connection_Line = []
    for connection in Microcircuit_Config[3+x]:
        Connection_Line.append(float(connection))
    Input_Connections.append(Connection_Line)
print(Input_Connections)

Internal_Connections = []
for x in range(0, Numb_Neurons):
    Connection_Line = []
    for connection in Microcircuit_Config[3+Numb_Inputs+x]:
        Connection_Line.append(float(connection))
    Internal_Connections.append(Connection_Line)
print(Internal_Connections)

Output_Connections = []
for x in range(0, Numb_Outputs):
    Output_Connections.append(int(Microcircuit_Config[3+Numb_Inputs+Numb_Neurons+x][0]))
print(Output_Connections)

Input_Indices = []
with open(stimulus_indices, newline='') as csv_file:
    csv_reader = csv.reader(csv_file, delimiter=',')
    for row in csv_reader:
        for value in row:
            Input_Indices.append(int(float(value)))

Input_Times = []
with open(stimulus_times, newline='') as csv_file:
    csv_reader = csv.reader(csv_file, delimiter=',')
    for row in csv_reader:
        for value in row:
            Input_Times.append(float(value) * ms)


tau = 25 * ms
eqs = '''
dv/dt = (In - v) / tau : 1
In : 1
'''

Input_Spike_Generator = SpikeGeneratorGroup(Numb_Inputs, Input_Indices, Input_Times)
Input_Monitor = SpikeMonitor(Input_Spike_Generator)

Microcircuit_Neurons = NeuronGroup(len(Internal_Connections), eqs, threshold='v > 1', reset='v = 0', method='exact')
Input_Synapses = Synapses(Input_Spike_Generator, Microcircuit_Neurons, 'w : 1', on_pre='v_post += w')
for x in range(len(Input_Connections)):
    for y in range(len(Input_Connections[x])):
        if Input_Connections[x][y] != 0:
            Input_Synapses.connect(i=x, j=y)
            Input_Synapses.w[-1] = Input_Connections[x][y]

Microcircuit_Synapses = Synapses(Microcircuit_Neurons, Microcircuit_Neurons, 'w : 1', on_pre='v_post += w')
for x in range(len(Internal_Connections)):
    for y in range(len(Internal_Connections[x])):
        if Internal_Connections[x][y] != 0:
            Microcircuit_Synapses.connect(i=x, j=y)
            Microcircuit_Synapses.w[-1] = Internal_Connections[x][y]

Internal_State_Monitor = StateMonitor(Microcircuit_Neurons, 'v', record=True)
Internal_Spike_Monitor = SpikeMonitor(Microcircuit_Neurons)

run(Run_Duration)

Input_Spike_Trains = Input_Monitor.spike_trains()
Internal_Spike_Trains = Internal_Spike_Monitor.spike_trains()

fig_1, axs_1 = subplots(Numb_Inputs + Numb_Outputs, sharex='col')
fig_1.tight_layout()

for x in range(0, Numb_Inputs):
    axs_1[x].eventplot(Input_Spike_Trains[x])
    axs_1[x].set_title('Input {}'.format(x))
    axs_1[x].set_xlim([0, Run_Duration])
    axs_1[x].set_ylim([0.5, 1])

for x in range(0, Numb_Outputs):
    axs_1[Numb_Inputs + x].eventplot(Internal_Spike_Trains[Output_Connections[x]])
    axs_1[Numb_Inputs + x].set_title('Output {}'.format(x))
    axs_1[Numb_Inputs + x].set_xlim([0, Run_Duration])
    axs_1[Numb_Inputs + x].set_ylim([0.5, 1])

if Plot_Type == 'full':
    print('showing all neuron activity')
    fig_2, axs_2 = subplots(Numb_Neurons, sharex='col')
    fig_2.tight_layout()

    for x in range(0, Numb_Neurons):
        axs_2[x].eventplot(Internal_Spike_Trains[x])
        axs_2[x].set_title('Neuron {}'.format(x))
        axs_2[x].set_xlim([0, Run_Duration])
        axs_2[x].set_ylim([0.5, 1])

show()
