/* SZTOA example usage - size_t to alphanumeric string.
 * Oliver Dixon <od641@york.ac.uk>, 2022. Public Domain. */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdint.h>

#include "sztoa.h"

/* main: testing driver for sztoa. */

int main ( )
{
        /* Begin testing parameters. */

        const size_t buf_sz = 17;
        const unsigned int base = 2;

        /* Uncomment to test a custom alphabet. */
        /* const char * alph = "AB"; */
        const char * alph = NULL;

        /* End testing parameters. */

        char buffer [ buf_sz ];

        /* Test execution: integers from 0x0000 through 0xFFFF in binary. */

        for ( uint64_t i = 0; i <= 0xFFFF; i++ ) {
                errno = 0;
                fputs ( sztoa ( buffer, i, buf_sz, base, alph ), stdout );

                if ( errno ) {
                        fputs ( "_(", stdout );
                        fputs ( strerror ( errno ), stdout );
                        puts  ( ")" );
                } else
                        putchar ( '\n' );
        }

        return 0;
}

