#include <stdlib.h> /* Included for `malloc'. */

/* A constant array of function pointers, named
 * `arithmetic', that contains functions returning a single
 * integer and accepting a couple of integer arguments. In
 * this case, it is initialised as a standard array with the
 * optional ampersand. */

int ( * const arithmetic [ ] ) ( int, int )
        = { &add, &multiply, &subtract, &divide };

/* A function pointer, named `allocator', that refers to a
 * function returning a void pointer and taking a single
 * argument of type `size_t'. This is initialised to the
 * standard `malloc' function, omitting the optional
 * ampersand. This pointer is non-constant, and may be
 * changed over time. */

void * ( * allocator ) ( size_t ) = malloc;
