#include <errno.h>

static int op_add ( int a, int b ) { return a + b; }
static int op_sub ( int a, int b ) { return a - b; }
static int op_mul ( int a, int b ) { return a * b; }
static int op_div ( int a, int b ) { return a / b; }

int calc ( char op, int a, int b )
{
        int ( * op_func ) ( int, int );

        switch ( op ) {
                case '+': op_func = op_add; break;
                case '-': op_func = op_sub; break;
                case '*': op_func = op_mul; break;
                case '/': op_func = op_div; break;

                default : return ( errno = EOPNOTSUPP, 0 );
        }

        return op_func ( a, b );
}

