/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.shiftone.jrat.core.spi.ShutdownListener;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ShutdownHook
extends Thread {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$ShutdownHook == null ? (class$org$shiftone$jrat$core$ShutdownHook = ShutdownHook.class$("org.shiftone.jrat.core.ShutdownHook")) : class$org$shiftone$jrat$core$ShutdownHook);
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private Stack shutdownStack = new Stack();
    private Set listenerSet = new HashSet();
    private boolean installed = false;
    private boolean shutDown = false;
    static /* synthetic */ Class class$org$shiftone$jrat$core$ShutdownHook;

    public void run() {
        Thread.currentThread().setName("JRat-Shutdown");
        try {
            this.shutdownNow();
        }
        catch (Exception e) {
            LOG.error("shutdown error", e);
        }
    }

    public synchronized void shutdownNow() {
        ShutdownListener listener = null;
        this.shutDown = true;
        this.listenerSet = null;
        LOG.info("JRat shutting down...");
        while (!this.shutdownStack.isEmpty()) {
            listener = (ShutdownListener)this.shutdownStack.pop();
            LOG.info(this.size() + " " + listener + " shutting down...");
            try {
                long start = System.currentTimeMillis();
                listener.shutdown();
                LOG.info(this.size() + " " + listener + " shutdown in " + (System.currentTimeMillis() - start) + "ms");
            }
            catch (Exception e) {
                System.err.println(this.size() + " " + listener + " failed to shutdown");
                e.printStackTrace(System.err);
                LOG.error(this.size() + " " + listener + " failed to shutdown", e);
            }
        }
        LOG.info("JRat shutdown complete.");
    }

    public synchronized void addShutdownListener(ShutdownListener listener) {
        if (this.shutDown) {
            LOG.info("not adding new listeners durning shutdown : " + listener);
            return;
        }
        if (listener == null) {
            LOG.info("shutdown listener is NULL");
        } else if (!this.listenerSet.contains(listener)) {
            this.install();
            this.shutdownStack.push(listener);
            this.listenerSet.add(listener);
            LOG.info("added for shutdown : " + this.shutdownStack.size() + " " + listener);
        } else {
            LOG.info("shutdown listener already registered : " + listener);
        }
    }

    public int size() {
        return this.shutdownStack.size();
    }

    public void install() {
        if (!this.installed) {
            RUNTIME.addShutdownHook(this);
            this.installed = true;
            LOG.debug("shutdown hook installed");
        }
    }

    public void uninstall() {
        if (this.installed) {
            RUNTIME.removeShutdownHook(this);
            this.installed = false;
            LOG.debug("shutdown hook removed");
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

