/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.spi;

import java.awt.Component;
import java.util.Properties;
import org.shiftone.jrat.core.OutputViewerException;
import org.shiftone.jrat.core.spi.AbstractOutputXmlViewerFactory;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.ResourceUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ViewerXmlHandler
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$spi$ViewerXmlHandler == null ? (class$org$shiftone$jrat$core$spi$ViewerXmlHandler = ViewerXmlHandler.class$("org.shiftone.jrat.core.spi.ViewerXmlHandler")) : class$org$shiftone$jrat$core$spi$ViewerXmlHandler);
    private AbstractOutputXmlViewerFactory xmlViewerFactory = null;
    private Component component = null;
    private int depth = 0;
    private long startTimeMs = 0L;
    static /* synthetic */ Class class$org$shiftone$jrat$core$spi$ViewerXmlHandler;

    public ViewerXmlHandler(AbstractOutputXmlViewerFactory xmlViewerFactory) {
        Assert.assertNotNull("AbstractOutputXmlViewerFactory", xmlViewerFactory);
        this.xmlViewerFactory = xmlViewerFactory;
    }

    public Component getComponent() {
        return this.component;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xmlViewerFactory.textElement(new String(ch, start, length));
        }
        catch (OutputViewerException e) {
            throw new SAXException("characters/textElement failed");
        }
    }

    public void startDocument() throws SAXException {
        this.startTimeMs = System.currentTimeMillis();
    }

    public void endDocument() throws SAXException {
        try {
            LOG.info("parse took " + (System.currentTimeMillis() - this.startTimeMs) + "ms");
            this.component = this.xmlViewerFactory.endDocumentCreateViewer();
            LOG.info("got " + this.component + " from " + this.xmlViewerFactory);
        }
        catch (OutputViewerException e) {
            throw new SAXException("endDocument/endDocumentCreateViewer failed");
        }
    }

    private AbstractOutputXmlViewerFactory getOutputXMLViewerFactory(Properties props) throws SAXException {
        AbstractOutputXmlViewerFactory factory = null;
        String viewerClass = props.getProperty("viewer");
        Object object = null;
        if (viewerClass == null) {
            throw new SAXException("attribute not correctly defined on root XML element");
        }
        try {
            object = ResourceUtil.newInstance(viewerClass);
            factory = (AbstractOutputXmlViewerFactory)object;
        }
        catch (Exception e) {
            throw new SAXException("error creating instance of XML viewer factory", e);
        }
        return factory;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Properties props = new Properties();
        ++this.depth;
        for (int i = 0; i < attributes.getLength(); ++i) {
            props.put(attributes.getQName(i), attributes.getValue(i));
        }
        try {
            if (this.depth == 1) {
                this.xmlViewerFactory = this.getOutputXMLViewerFactory(props);
                this.xmlViewerFactory.startDocument();
            }
            this.xmlViewerFactory.startElement(qName, props);
        }
        catch (OutputViewerException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.xmlViewerFactory.endElement(qName);
            --this.depth;
        }
        catch (OutputViewerException e) {
            throw new SAXException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

