/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.jda;

import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import java.util.List;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ThreadTracer {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$jda$ThreadTracer == null ? (class$org$shiftone$jrat$jda$ThreadTracer = ThreadTracer.class$("org.shiftone.jrat.jda.ThreadTracer")) : class$org$shiftone$jrat$jda$ThreadTracer);
    private ThreadReference thread = null;
    private int depth = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$jda$ThreadTracer;

    public ThreadTracer(ThreadReference threadReference) {
        this.thread = threadReference;
        try {
            this.thread.suspend();
            this.depth = this.thread.frameCount();
            List<StackFrame> frames = this.thread.frames();
            this.log(frames.size() + " =? " + this.thread.frameCount());
            for (int i = 0; i < frames.size(); ++i) {
                this.log(frames.get(i));
            }
            this.thread.resume();
        }
        catch (Exception e) {
            LOG.warn("", e);
        }
    }

    private String indent() {
        String x = this.depth + ":";
        return x;
    }

    private void log(Object message) {
        LOG.info(this.indent() + " " + this.thread.name() + " - " + message);
    }

    public void processMethodEntryEvent(MethodEntryEvent methodEntryEvent) throws Exception {
        ++this.depth;
        if (this.depth < 50) {
            Method method = methodEntryEvent.method();
            this.log(">" + method.declaringType().name() + ":" + method.name());
        }
    }

    public void processMethodExitEvent(MethodExitEvent methodExitEvent) throws Exception {
        if (this.depth < 50) {
            Method method = methodExitEvent.method();
            this.log("<" + method.declaringType().name() + ":" + method.name());
        }
        --this.depth;
    }

    public void processEvent(LocatableEvent locatableEvent) throws Exception {
        if (locatableEvent instanceof MethodEntryEvent) {
            this.processMethodEntryEvent((MethodEntryEvent)locatableEvent);
        } else if (locatableEvent instanceof MethodExitEvent) {
            this.processMethodExitEvent((MethodExitEvent)locatableEvent);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

