/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log;

import java.io.OutputStream;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.spi.AbstractMethodHandlerFactory;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.provider.log.LogMethodHandler;
import org.shiftone.jrat.provider.log.io.LogOutput;
import org.shiftone.jrat.util.Sequence;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class LogMethodHandlerFactory
extends AbstractMethodHandlerFactory {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$log$LogMethodHandlerFactory == null ? (class$org$shiftone$jrat$provider$log$LogMethodHandlerFactory = LogMethodHandlerFactory.class$("org.shiftone.jrat.provider.log.LogMethodHandlerFactory")) : class$org$shiftone$jrat$provider$log$LogMethodHandlerFactory);
    public static final String DEFAULT_OUTPUT_FILE_NAME = "Log";
    private Sequence threadSeq = null;
    private Sequence messageSeq = null;
    private ThreadLocal threadLocal = new ThreadLocal();
    private RuntimeContext context = null;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$LogMethodHandlerFactory;

    public LogMethodHandlerFactory() {
        this.threadSeq = new Sequence();
        this.messageSeq = new Sequence();
    }

    public MethodHandler createMethodHandler(MethodKey methodKey) {
        return new LogMethodHandler(methodKey, this);
    }

    private static String threadName(Thread thread) {
        return StringUtil.hex(thread.hashCode()) + "-" + StringUtil.removeNonLetterOrDigit(thread.getThreadGroup().getName()) + "-" + StringUtil.removeNonLetterOrDigit(thread.getName());
    }

    private LogOutput newLogOutput() {
        LogOutput logOutput = null;
        OutputStream outputStream = null;
        String threadName = LogMethodHandlerFactory.threadName(Thread.currentThread());
        int threadId = (int)this.threadSeq.getNextValue();
        try {
            outputStream = this.context.newOutputStream(this.getOutputFile() + "-" + threadName + ".jrat", this.isCompressOutput());
            logOutput = new LogOutput(outputStream, this.messageSeq);
            this.context.addShutdownListener(logOutput);
        }
        catch (Exception e) {
            // empty catch block
        }
        return logOutput;
    }

    public synchronized LogOutput getLogOutput() {
        LogOutput logOutput = (LogOutput)this.threadLocal.get();
        if (logOutput == null) {
            logOutput = this.newLogOutput();
            this.threadLocal.set(logOutput);
        }
        return logOutput;
    }

    public String getDefaultOutputFile() {
        return DEFAULT_OUTPUT_FILE_NAME;
    }

    public synchronized void flush() {
        LOG.info("flush");
    }

    public synchronized void shutdown() {
        LOG.info("shutdown");
    }

    public void startup(RuntimeContext context) {
        this.context = context;
        context.addShutdownListener(this);
    }

    public String toString() {
        return "Log Handler Factory";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

