/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.shiftone.jrat.provider.log.io.LogFileFormatException;
import org.shiftone.jrat.provider.log.io.LogInput;
import org.shiftone.jrat.provider.log.io.message.CloseMessage;
import org.shiftone.jrat.provider.log.io.message.Message;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class RandomAccessLogFile {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$log$io$RandomAccessLogFile == null ? (class$org$shiftone$jrat$provider$log$io$RandomAccessLogFile = RandomAccessLogFile.class$("org.shiftone.jrat.provider.log.io.RandomAccessLogFile")) : class$org$shiftone$jrat$provider$log$io$RandomAccessLogFile);
    private File file = null;
    private RandomAccessFile raf = null;
    private LogInput logInput = null;
    private List pageList = null;
    private int messageCount = 0;
    private int pageSizeInMessages = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$io$RandomAccessLogFile;

    public RandomAccessLogFile(File file) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "r");
        this.logInput = new LogInput(this.raf);
    }

    public void initialize() throws IOException {
        this.raf.seek(this.raf.length() - 1L);
        byte lastByte = this.raf.readByte();
        if (lastByte == 26) {
            try {
                this.initializeTheEasyWay();
            }
            catch (Exception e) {
                LOG.warn("the easy way failed.. trying the hard way");
                this.initializeTheHardWay();
            }
        } else {
            this.initializeTheHardWay();
        }
        LOG.info("messageCount = " + this.messageCount);
    }

    private void initializeTheEasyWay() throws IOException {
        LOG.info("initializeTheEasyWay");
        this.raf.seek(this.raf.length() - 5L);
        int footerStartOffset = this.raf.readInt();
        this.raf.seek(footerStartOffset);
        Message message = this.logInput.readMessage();
        if (!(message instanceof CloseMessage)) {
            throw new LogFileFormatException("message footer is badly formatted");
        }
        byte b = this.raf.readByte();
        if (b != 111) {
            throw new LogFileFormatException("message footer offset table is badly formatted " + b);
        }
        this.pageSizeInMessages = this.raf.readInt();
        this.messageCount = this.raf.readInt();
        int pages = this.raf.readInt();
        this.pageList = new ArrayList(pages);
        for (int i = 0; i < pages; ++i) {
            Page page = new Page();
            page.fileOffset = this.raf.readInt();
            this.pageList.add(page);
        }
        LOG.info("initialized page table the easy way " + this.pageList);
    }

    private void initializeTheHardWay() throws IOException {
        Message message;
        LOG.info("initializeTheHardWay");
        this.pageList = new ArrayList();
        this.raf.seek(1L);
        this.logInput.readPreamble();
        this.pageSizeInMessages = 18432;
        while ((message = this.logInput.readMessage()) != null && !(message instanceof CloseMessage)) {
            if (this.messageCount % this.pageSizeInMessages == 0) {
                Page page = new Page();
                page.fileOffset = (int)this.raf.getFilePointer();
                this.pageList.add(page);
            }
            Thread.yield();
            ++this.messageCount;
        }
        LOG.info("initialized page table the hard way " + this.pageList);
    }

    private static void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getMethodMessageCount() {
        return this.messageCount;
    }

    public Message getMessage(long index) throws IOException {
        Object message = null;
        Page page = null;
        int pageNumber = (int)(index / (long)this.pageSizeInMessages);
        long pageStart = pageNumber * this.pageSizeInMessages;
        int pageIndex = (int)(index - pageStart);
        page = this.getPageWithMessages(pageNumber);
        return page.messages[pageIndex];
    }

    private synchronized Page getPageWithMessages(int pageNumber) throws IOException {
        Page page = (Page)this.pageList.get(pageNumber);
        if (page.messages == null) {
            Message message;
            LOG.info("getPageWithMessages " + pageNumber);
            page.messages = new Message[this.pageSizeInMessages];
            this.raf.seek(page.fileOffset);
            for (int i = 0; (message = this.logInput.readMessage()) != null && !(message instanceof CloseMessage) && i < this.pageSizeInMessages; ++i) {
                page.messages[i] = message;
            }
        }
        return page;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Page {
        int fileOffset;
        Message[] messages;

        private Page() {
        }
    }
}

