/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.rate;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.shiftone.jrat.core.Accumulator;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.provider.rate.RateMethodHandler;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class RateOutput {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$rate$RateOutput == null ? (class$org$shiftone$jrat$provider$rate$RateOutput = RateOutput.class$("org.shiftone.jrat.provider.rate.RateOutput")) : class$org$shiftone$jrat$provider$rate$RateOutput);
    private static final Runtime RT = Runtime.getRuntime();
    private static final String TAB = "\t";
    public static final String PREFIX_METHOD = "METHOD";
    public static final String PREFIX_SAMPLE = "SAMPLE";
    public static final String PREFIX_SHUTDOWN = "SHUTDOWN";
    public static final String POSTFIX_END = "END";
    private int methodCount = 0;
    private int maxMethods = 0;
    private RuntimeContext context = null;
    private OutputStream outputStream = null;
    private Writer writer = null;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$rate$RateOutput;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$rate$ui$RateOutputViewerFactory;

    public RateOutput(OutputStream outputStream, int maxMethods, RuntimeContext context) {
        this.outputStream = outputStream;
        this.writer = new PrintWriter(outputStream);
        this.maxMethods = maxMethods;
        this.context = context;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    private void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    private void print(long number) throws IOException {
        this.print(String.valueOf(number));
    }

    private void println(long number) throws IOException {
        this.println(String.valueOf(number));
    }

    private void println(String text) throws IOException {
        this.print(text);
        this.print("\n");
    }

    private void print(String text) throws IOException {
        this.writer.write(text);
    }

    public synchronized int printMethodDef(MethodKey methodKey) throws IOException {
        int methodId = this.methodCount++;
        LOG.info("writeMethodDef : " + methodKey);
        this.print("METHOD\t");
        this.print(methodId);
        this.print(TAB);
        this.print(methodKey.getClassName());
        this.print(TAB);
        this.print(methodKey.getMethodName());
        this.print(TAB);
        this.print(methodKey.getSignature());
        this.println("\tEND");
        return methodId;
    }

    public synchronized void printHeader(long period) throws IOException {
        LOG.info("writeHeader " + period);
        this.print("viewer=\"");
        this.print((class$org$shiftone$jrat$provider$rate$ui$RateOutputViewerFactory == null ? (class$org$shiftone$jrat$provider$rate$ui$RateOutputViewerFactory = RateOutput.class$("org.shiftone.jrat.provider.rate.ui.RateOutputViewerFactory")) : class$org$shiftone$jrat$provider$rate$ui$RateOutputViewerFactory).getName());
        this.println("\"");
        this.println(this.maxMethods);
        this.println(this.context.getStartTimeMs());
        this.println(System.currentTimeMillis());
        this.println(period);
    }

    public synchronized void printSample(RateMethodHandler[] handlers) throws IOException {
        RateMethodHandler handler = null;
        Accumulator accumulator = null;
        long time = this.context.getUpTimeMs();
        long totalMemory = RT.totalMemory();
        long freeMemory = RT.freeMemory();
        this.print("SAMPLE\t");
        this.print(time);
        this.print(',');
        this.print(freeMemory);
        this.print(',');
        this.print(totalMemory);
        for (int i = 0; i < this.methodCount; ++i) {
            handler = handlers[i];
            accumulator = handler.getAndReplaceAccumulator();
            this.print(TAB);
            this.print(Accumulator.toCSV(accumulator));
        }
        this.println("\tEND");
    }

    public synchronized void close() throws IOException {
        LOG.info("close");
        this.print("SHUTDOWN\t");
        this.print(System.currentTimeMillis());
        this.print(TAB);
        this.print(this.context.getUpTimeMs());
        this.println("\tEND");
        this.writer.flush();
        this.writer.close();
        this.outputStream.flush();
        this.outputStream.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

