/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends BufferedInputStream {
    private long bytesReadMark = 0L;
    private long bytesRead = 0L;

    public CountingInputStream(InputStream in, int size) {
        super(in, size);
    }

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public synchronized int read() throws IOException {
        int read = super.read();
        if (read >= 0) {
            ++this.bytesRead;
        }
        return read;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read >= 0) {
            this.bytesRead += (long)read;
        }
        return read;
    }

    public synchronized long skip(long n) throws IOException {
        long skipped = super.skip(n);
        if (skipped >= 0L) {
            this.bytesRead += skipped;
        }
        return skipped;
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.bytesReadMark = this.bytesRead;
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.bytesRead = this.bytesReadMark;
    }
}

