/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class MethodKeyPool {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$MethodKeyPool == null ? (class$org$shiftone$jrat$core$MethodKeyPool = MethodKeyPool.class$("org.shiftone.jrat.core.MethodKeyPool")) : class$org$shiftone$jrat$core$MethodKeyPool);
    private int idSequence = 0;
    private Map method2IdMap = new HashMap();
    private Map id2MethodMap = new HashMap();
    static /* synthetic */ Class class$org$shiftone$jrat$core$MethodKeyPool;

    public synchronized MethodKey getMethodKey(String className, String methodName, String signature) {
        MethodKey key = new MethodKey(className, methodName, signature);
        if (this.method2IdMap.containsKey(key)) {
            KeyAndId entry = (KeyAndId)this.method2IdMap.get(key);
            key = entry.methodKey;
        } else {
            this.addMapping(key, "m" + this.idSequence);
            ++this.idSequence;
        }
        return key;
    }

    public String getId(MethodKey methodKey) {
        KeyAndId keyAndId = (KeyAndId)this.method2IdMap.get(methodKey);
        return keyAndId != null ? keyAndId.id : null;
    }

    public synchronized void addMapping(MethodKey methodKey, String id) {
        if (this.method2IdMap.containsKey(methodKey)) {
            throw new RuntimeException("method key already exists in pool : " + methodKey);
        }
        if (this.id2MethodMap.containsKey(id)) {
            throw new RuntimeException("method ID already exists in pool : " + id);
        }
        KeyAndId keyAndId = new KeyAndId();
        keyAndId.id = id;
        keyAndId.methodKey = methodKey;
        this.method2IdMap.put(methodKey, keyAndId);
        this.id2MethodMap.put(id, methodKey);
    }

    public void printXML(PrintStream out, int indent) {
        KeyAndId keyAndId = null;
        String indentString = StringUtil.bufferString(indent, ' ');
        Collection values = this.method2IdMap.values();
        Iterator iterator = values.iterator();
        out.println(indentString + "<method-pool>");
        while (iterator.hasNext()) {
            keyAndId = (KeyAndId)iterator.next();
            out.print(indentString + " ");
            out.print("<method id=\"" + keyAndId.id + "\"");
            out.print(" class=\"" + keyAndId.methodKey.getClassName() + "\"");
            out.print(" method=\"" + keyAndId.methodKey.getMethodName() + "\"");
            out.print(" signature=\"" + keyAndId.methodKey.getSignature() + "\" />");
            out.println();
        }
        out.println(indentString + "</method-pool>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class KeyAndId {
        MethodKey methodKey = null;
        String id = null;

        private KeyAndId() {
        }
    }
}

