/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.shiftone.jrat.inject.ClassInjector;
import org.shiftone.jrat.inject.InjectionException;
import org.shiftone.jrat.inject.criteria.InjectionCriteria;
import org.shiftone.jrat.inject.process.AbstractProcessor;
import org.shiftone.jrat.inject.process.ClassProcessor;
import org.shiftone.jrat.inject.process.CopyProcessor;
import org.shiftone.jrat.inject.process.JarProcessor;
import org.shiftone.jrat.inject.process.Processor;
import org.shiftone.jrat.inject.process.WarProcessor;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class Injector {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$inject$Injector == null ? (class$org$shiftone$jrat$inject$Injector = Injector.class$("org.shiftone.jrat.inject.Injector")) : class$org$shiftone$jrat$inject$Injector);
    public static final String WORK_FILE_END = "-JRatWorkFile";
    private boolean forceOverwrite = false;
    private boolean overwriteNewer = false;
    private boolean preserveLastModified = false;
    private InjectionCriteria injectionCriteria = new InjectionCriteria();
    static /* synthetic */ Class class$org$shiftone$jrat$inject$Injector;

    public byte[] injectStream(InputStream inputStream, String fileName) throws IOException, ClassFormatError {
        JavaClass javaClass = null;
        ClassParser classParser = null;
        classParser = new ClassParser(inputStream, fileName);
        javaClass = classParser.parse();
        javaClass = ClassInjector.injectClass(javaClass, this.injectionCriteria);
        return javaClass.getBytes();
    }

    public void inject(File sourceFile, File targetFile) throws InjectionException {
        Processor processor = null;
        String sourceExt = IOUtil.getExtention(sourceFile);
        String targetExt = IOUtil.getExtention(targetFile);
        File targetDir = targetFile.getParentFile();
        if (!sourceExt.equals(targetExt)) {
            throw new InjectionException("source and target file extention are not the same");
        }
        if (targetDir != null && !targetDir.exists() && !targetDir.mkdirs()) {
            throw new InjectionException("error creating parent directory of target file : " + targetDir);
        }
        processor = this.getCorrectProcessor(sourceExt);
        try {
            processor.process(this, sourceFile, targetFile);
        }
        catch (IOException e) {
            throw new InjectionException("injection failed do to file access error\n" + sourceFile + " -> " + targetFile, e);
        }
    }

    private Processor getCorrectProcessor(String fileExt) {
        AbstractProcessor processor = null;
        processor = fileExt.equalsIgnoreCase("class") ? new ClassProcessor() : (fileExt.equalsIgnoreCase("jar") ? new JarProcessor() : (fileExt.equalsIgnoreCase("war") ? new WarProcessor() : new CopyProcessor()));
        return processor;
    }

    public void inject(String source, String target) throws InjectionException {
        this.inject(new File(source), new File(target));
    }

    public void inject(File file) throws InjectionException {
        if (file.getName().endsWith(WORK_FILE_END)) {
            try {
                IOUtil.delete(file);
            }
            catch (IOException e) {
                LOG.warn("unable to delete : " + file);
            }
        } else {
            this.inject(file, file);
        }
    }

    public void inject(String fileName) throws InjectionException {
        this.inject(new File(fileName));
    }

    public boolean isBCELPresent() {
        try {
            Class.forName("org.apache.bcel.Repository");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public InjectionCriteria getInjectionCriteria() {
        return this.injectionCriteria;
    }

    public void setInjectionCriteria(InjectionCriteria injectionCriteria) {
        this.injectionCriteria = injectionCriteria;
    }

    public boolean isForceOverwrite() {
        return this.forceOverwrite;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public boolean isOverwriteNewer() {
        return this.overwriteNewer;
    }

    public void setOverwriteNewer(boolean overwriteNewer) {
        this.overwriteNewer = overwriteNewer;
    }

    public boolean isPreserveLastModified() {
        return this.preserveLastModified;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

