/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.shiftone.jrat.inject.InjectionException;
import org.shiftone.jrat.inject.Injector;
import org.shiftone.jrat.inject.process.Processor;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public abstract class AbstractProcessor
implements Processor {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$inject$process$AbstractProcessor == null ? (class$org$shiftone$jrat$inject$process$AbstractProcessor = AbstractProcessor.class$("org.shiftone.jrat.inject.process.AbstractProcessor")) : class$org$shiftone$jrat$inject$process$AbstractProcessor);
    private static final long DEFAULT_BUFFER_SIZE = 6144L;
    private boolean forceOverwrite = true;
    private boolean overwriteNewer = false;
    private boolean preserveLastModified = false;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$process$AbstractProcessor;

    public boolean process(Injector injector, File source, File target) throws InjectionException, IOException {
        boolean worked = false;
        if (!source.exists()) {
            throw new IOException("source file does not exist : " + source);
        }
        if (source.isDirectory()) {
            throw new IOException("source file is a directory : " + source);
        }
        if (!source.canRead()) {
            throw new IOException("source file can not be read (check permissions): " + source);
        }
        long lastModified = source.lastModified();
        if (target.exists()) {
            if (!this.forceOverwrite) {
                LOG.debug("target exists and forceOverwrite is disabled : " + source);
                return false;
            }
            if (target.isDirectory()) {
                throw new IOException("target is directory : " + target);
            }
            if (!target.canWrite()) {
                throw new IOException("unable to write to target (check permissions) : " + target);
            }
            if (target.lastModified() > source.lastModified() && !this.overwriteNewer) {
                LOG.info("target is newer than source and overwriteNewer is disabled : " + source);
                return false;
            }
            worked = this.processUsingSwapFile(injector, source, target);
        } else {
            worked = this.processFile(injector, source, target);
        }
        if (this.preserveLastModified) {
            target.setLastModified(lastModified);
        }
        return worked;
    }

    protected boolean processUsingSwapFile(Injector injector, File source, File target) throws InjectionException, IOException {
        boolean worked = false;
        File workFile = new File(target.getAbsolutePath() + "-JRatWorkFile");
        if (workFile.exists()) {
            LOG.info("workfile found, deleting");
            IOUtil.delete(workFile);
        }
        try {
            worked = this.processFile(injector, source, workFile);
            if (worked && !workFile.exists()) {
                throw new InjectionException("processFile claims to have worked, but target file doesn't exist : " + source);
            }
            if (!worked && workFile.exists()) {
                throw new InjectionException("processFile caims to have failed, but workfile exists : " + workFile);
            }
            if (worked) {
                IOUtil.rename(workFile, target, true);
            }
        }
        catch (Exception e) {
            String msg = "Failed to instrument " + source;
            if (workFile.exists() && !workFile.delete()) {
                msg = msg + " and couldn't delete the corrupt file " + workFile.getAbsolutePath();
            }
            throw new InjectionException(msg, e);
        }
        return worked;
    }

    protected boolean processFile(Injector injector, File source, File target) throws InjectionException, IOException {
        BufferedInputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        int bufferSize = (int)Math.min(6144L, source.length());
        inputStream = new BufferedInputStream(new FileInputStream(source), bufferSize);
        outputStream = new BufferedOutputStream(new FileOutputStream(target), bufferSize);
        return this.processStream(injector, inputStream, outputStream, source.getName());
    }

    protected boolean processStream(Injector injector, InputStream inputStream, OutputStream outputStream, String fileName) throws InjectionException, IOException {
        throw new UnsupportedOperationException("processStream should be implemented by derived class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

