/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.ui.StackTreeNode;
import org.shiftone.jrat.util.Percent;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class StackTableModel
implements TableModel {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$tree$ui$StackTableModel == null ? (class$org$shiftone$jrat$provider$tree$ui$StackTableModel = StackTableModel.class$("org.shiftone.jrat.provider.tree.ui.StackTableModel")) : class$org$shiftone$jrat$provider$tree$ui$StackTableModel);
    private StackTreeNode node = null;
    private List stack = null;
    private String[] COLUMN_NAMES = new String[]{"Class", "Method", "Signature", "Enters", "Exits", "Errors", "Total ms", "Avg ms", "Std Dev", "Min ms", "Max ms", "%Parent", "%Root"};
    private Class[] COLUMN_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StackTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StackTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = StackTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Long == null ? (class$java$lang$Long = StackTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StackTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StackTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StackTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = StackTableModel.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = StackTableModel.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Long == null ? (class$java$lang$Long = StackTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Long == null ? (class$java$lang$Long = StackTableModel.class$("java.lang.Long")) : class$java$lang$Long, class$org$shiftone$jrat$util$Percent == null ? (class$org$shiftone$jrat$util$Percent = StackTableModel.class$("org.shiftone.jrat.util.Percent")) : class$org$shiftone$jrat$util$Percent, class$org$shiftone$jrat$util$Percent == null ? (class$org$shiftone$jrat$util$Percent = StackTableModel.class$("org.shiftone.jrat.util.Percent")) : class$org$shiftone$jrat$util$Percent};
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$StackTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$shiftone$jrat$util$Percent;

    public StackTableModel() {
        this.stack = new ArrayList();
    }

    public StackTableModel(StackTreeNode node) {
        this.node = node;
        this.stack = new ArrayList();
        StackTreeNode currNode = node;
        while (currNode.getParent() != null) {
            this.stack.add(currNode);
            currNode = (StackTreeNode)currNode.getParentNode();
        }
    }

    public int getRowCount() {
        return this.stack.size();
    }

    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public String getColumnName(int columnIndex) {
        return this.COLUMN_NAMES[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return this.COLUMN_TYPES[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        StackTreeNode node = (StackTreeNode)this.stack.get(rowIndex);
        MethodKey methodKey = node.getMethodKey();
        if (methodKey == null) {
            return "?";
        }
        switch (columnIndex) {
            case 0: {
                return methodKey.getClassName();
            }
            case 1: {
                return methodKey.getMethodName();
            }
            case 2: {
                return methodKey.getSignature();
            }
            case 3: {
                return new Long(node.getTotalEnters());
            }
            case 4: {
                return new Long(node.getTotalExits());
            }
            case 5: {
                return new Long(node.getTotalErrors());
            }
            case 6: {
                return new Long(node.getTotalDuration());
            }
            case 7: {
                return node.getAverageDuration();
            }
            case 8: {
                return node.getStdDeviation();
            }
            case 9: {
                return node.getMinDuration();
            }
            case 10: {
                return node.getMaxDuration();
            }
            case 11: {
                return new Percent(node.getPctOfAvgParentDuration());
            }
            case 12: {
                return new Percent(node.getPctOfAvgRootDuration());
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

