/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.test;

import java.util.Properties;
import junit.framework.TestCase;
import org.shiftone.jrat.util.PropertiesTree;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class PropertiesTreeTestCase
extends TestCase {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$test$PropertiesTreeTestCase == null ? (class$org$shiftone$jrat$test$PropertiesTreeTestCase = PropertiesTreeTestCase.class$("org.shiftone.jrat.test.PropertiesTreeTestCase")) : class$org$shiftone$jrat$test$PropertiesTreeTestCase);
    static /* synthetic */ Class class$org$shiftone$jrat$test$PropertiesTreeTestCase;

    public void testSimple() throws Exception {
        Properties origProps = new Properties();
        Properties newProps = null;
        int i = 0;
        origProps.put("one.two.three", "value" + i++);
        origProps.put("one.two.four", "value" + i++);
        origProps.put("one.alpha.four", "value" + i++);
        origProps.put("one.alpha.five", "value" + i++);
        origProps.put("one.alpha.six.7.8.9", "value" + i++);
        origProps.put("one.alpha.six.7.8.TARGET", "BULLSEYE");
        origProps.put("one.alpha.six.test", "value" + i++);
        origProps.put("single", "value" + i++);
        origProps.put("single.double", "value" + i++);
        PropertiesTree tree = new PropertiesTree(origProps);
        tree.print(System.out);
        PropertiesTree.Node targetNode = tree.getNode("one.alpha.six.7.8.TARGET");
        PropertiesTree.Node sixNode = tree.getNode("one.alpha.six");
        PropertiesTree.Node alphaNode = tree.getNode("one.alpha");
        PropertiesTreeTestCase.assertNotNull((Object)targetNode);
        PropertiesTreeTestCase.assertEquals((String)"TARGET", (String)targetNode.getKey());
        PropertiesTreeTestCase.assertEquals((String)"BULLSEYE", (String)targetNode.getValue());
        PropertiesTreeTestCase.assertNotNull((Object)sixNode);
        PropertiesTreeTestCase.assertEquals((int)2, (int)sixNode.getChildren().size());
        PropertiesTreeTestCase.assertNotNull((Object)alphaNode);
        PropertiesTreeTestCase.assertEquals((int)3, (int)alphaNode.getChildren().size());
        newProps = tree.getProperties();
        newProps.list(System.out);
        PropertiesTreeTestCase.assertEquals((Object)origProps, (Object)newProps);
        alphaNode.createNode("newChild", "newChildValue");
        newProps = tree.getProperties();
        newProps.list(System.out);
        PropertiesTreeTestCase.assertNotSame((Object)origProps, (Object)newProps);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

