/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.viewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ProgressInputStream
extends InputStream {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$viewer$ProgressInputStream == null ? (class$org$shiftone$jrat$ui$viewer$ProgressInputStream = ProgressInputStream.class$("org.shiftone.jrat.ui.viewer.ProgressInputStream")) : class$org$shiftone$jrat$ui$viewer$ProgressInputStream);
    private InputStream inputStream = null;
    private DefaultBoundedRangeModel rangeModel = null;
    private long maxBytes = 0L;
    private long bytesRead = 0L;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$viewer$ProgressInputStream;

    public ProgressInputStream(InputStream inputStream, long maxBytes) {
        this.inputStream = inputStream;
        this.maxBytes = maxBytes;
        this.rangeModel = new DefaultBoundedRangeModel(0, 1, 0, (int)maxBytes);
    }

    public ProgressInputStream(File file) throws IOException {
        this(new FileInputStream(file), file.length());
    }

    public void close() throws IOException {
        LOG.debug("bytesRead = " + this.bytesRead);
        LOG.debug("maxBytes  = " + this.maxBytes);
        LOG.info("close");
        this.rangeModel.setValue(0);
        super.close();
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.rangeModel;
    }

    private void updateModel() {
        this.rangeModel.setValue((int)this.bytesRead);
    }

    public int read() throws IOException {
        int i = this.inputStream.read();
        if (i != -1 && this.bytesRead < this.maxBytes) {
            ++this.bytesRead;
            this.updateModel();
        }
        return i;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b) throws IOException {
        int i = super.read(b);
        if (i != -1 && this.bytesRead < this.maxBytes) {
            this.bytesRead += (long)i;
            this.updateModel();
        }
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = super.read(b, off, len);
        if (i != -1 && this.bytesRead < this.maxBytes) {
            this.bytesRead += (long)i;
            this.updateModel();
        }
        return i;
    }

    public long skip(long n) throws IOException {
        long i = super.skip(n);
        if (i != -1L && this.bytesRead < this.maxBytes) {
            this.bytesRead += i;
            this.updateModel();
        }
        return i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

