/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.viewer.tsv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.shiftone.jrat.ui.viewer.tsv.TsvComparator;
import org.shiftone.jrat.util.IntrospectionUtil;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class TsvTableModel
implements TableModel {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$viewer$tsv$TsvTableModel == null ? (class$org$shiftone$jrat$ui$viewer$tsv$TsvTableModel = TsvTableModel.class$("org.shiftone.jrat.ui.viewer.tsv.TsvTableModel")) : class$org$shiftone$jrat$ui$viewer$tsv$TsvTableModel);
    public static final String PREFIX_LONG = "#";
    public static final String PREFIX_DOUBLE = "@";
    public static final String PREFIX_PERCENT = "%";
    private Object[][] rows = null;
    private String[] columnNames = null;
    private Class[] columnTypes = null;
    private Set listener = new HashSet();
    static /* synthetic */ Class class$org$shiftone$jrat$ui$viewer$tsv$TsvTableModel;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$shiftone$jrat$util$Percent;
    static /* synthetic */ Class class$java$lang$String;

    public void load(InputStream inputStream) throws IOException {
        int i;
        InputStreamReader reader = new InputStreamReader(inputStream);
        LineNumberReader lineReader = new LineNumberReader(reader);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        String line = null;
        lineReader.readLine();
        this.columnNames = this.tokenize(lineReader.readLine());
        this.columnTypes = new Class[this.columnNames.length];
        for (i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i].startsWith(PREFIX_LONG)) {
                this.columnTypes[i] = class$java$lang$Long == null ? TsvTableModel.class$("java.lang.Long") : class$java$lang$Long;
                this.columnNames[i] = this.columnNames[i].substring(1);
                continue;
            }
            if (this.columnNames[i].startsWith(PREFIX_DOUBLE)) {
                this.columnTypes[i] = class$java$lang$Double == null ? TsvTableModel.class$("java.lang.Double") : class$java$lang$Double;
                this.columnNames[i] = this.columnNames[i].substring(1);
                continue;
            }
            if (this.columnNames[i].startsWith(PREFIX_PERCENT)) {
                this.columnTypes[i] = class$org$shiftone$jrat$util$Percent == null ? TsvTableModel.class$("org.shiftone.jrat.util.Percent") : class$org$shiftone$jrat$util$Percent;
                this.columnNames[i] = this.columnNames[i].substring(1);
                continue;
            }
            this.columnTypes[i] = class$java$lang$String == null ? TsvTableModel.class$("java.lang.String") : class$java$lang$String;
        }
        while ((line = lineReader.readLine()) != null) {
            Object[] row = new Object[this.columnNames.length];
            String[] str = this.tokenize(line);
            for (int i2 = 0; i2 < Math.min(str.length, this.columnNames.length); ++i2) {
                row[i2] = IntrospectionUtil.convertSafe(str[i2], this.columnTypes[i2]);
            }
            list.add(row);
        }
        this.rows = new Object[list.size()][];
        for (i = 0; i < list.size(); ++i) {
            this.rows[i] = (Object[])list.get(i);
        }
    }

    String[] tokenize(String string) {
        return StringUtil.tokenize(string, "\t,", false);
    }

    public void addTableModelListener(TableModelListener l) {
        this.listener.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(l);
    }

    public void notifyListeners(TableModelEvent event) {
        Iterator iterator = this.listener.iterator();
        while (iterator.hasNext()) {
            TableModelListener l = (TableModelListener)iterator.next();
            l.tableChanged(event);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = TsvTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] row = this.rows[rowIndex];
        return row[columnIndex];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void sortByColumn(int column, boolean ascending) {
        LOG.info("sortByColumn " + column + (ascending ? " assending" : " decending"));
        Arrays.sort(this.rows, new TsvComparator(column, ascending));
        this.notifyListeners(new TableModelEvent(this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

