/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class GlobMatcher {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$GlobMatcher == null ? (class$org$shiftone$jrat$util$GlobMatcher = GlobMatcher.class$("org.shiftone.jrat.util.GlobMatcher")) : class$org$shiftone$jrat$util$GlobMatcher);
    public static final GlobMatcher INCLUDE_ALL = new GlobMatcher("*");
    private char[][] patternParts = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$GlobMatcher;

    public GlobMatcher(String pattenString) {
        Assert.assertNotNull("pattenString", pattenString);
        this.patternParts = GlobMatcher.getPatternParts(pattenString);
    }

    public boolean isMatch(String inputString) {
        Assert.assertNotNull("inputString", inputString);
        return GlobMatcher.isMatch(inputString, this.patternParts);
    }

    private static char[][] getPatternParts(String pattenString) {
        String[] sections = StringUtil.tokenize(pattenString, "*", true);
        char[][] patternParts = new char[sections.length][];
        for (int i = 0; i < sections.length; ++i) {
            patternParts[i] = sections[i].toCharArray();
        }
        return patternParts;
    }

    public static boolean isMatch(String inputString, String pattenString) {
        return GlobMatcher.isMatch(inputString, GlobMatcher.getPatternParts(pattenString));
    }

    public static boolean isMatch(String input, char[][] patternParts) {
        char[] in = input.toCharArray();
        boolean canSkip = false;
        int currentIndex = 0;
        for (int i = 0; i < patternParts.length; ++i) {
            if (patternParts[i][0] == '*') {
                canSkip = true;
                continue;
            }
            if (!canSkip) {
                if (!GlobMatcher.matchesFixed(in, currentIndex, patternParts[i])) {
                    return false;
                }
            } else {
                int m = GlobMatcher.nextFixedMatch(in, currentIndex, patternParts[i]);
                if (m == -1) {
                    return false;
                }
                currentIndex = m + patternParts[i].length;
            }
            canSkip = false;
        }
        return true;
    }

    public static int nextFixedMatch(String cs, int offSet, String ps) {
        return GlobMatcher.nextFixedMatch(cs.toCharArray(), offSet, ps.toCharArray());
    }

    public static int nextFixedMatch(char[] cs, int offSet, char[] ps) {
        int endIndex = cs.length - ps.length + 1;
        for (int i = offSet; i < endIndex; ++i) {
            if (!GlobMatcher.matchesFixed(cs, i, ps)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchesFixed(String cs, int offSet, String ps) {
        return GlobMatcher.matchesFixed(cs.toCharArray(), offSet, ps.toCharArray());
    }

    public static boolean matchesFixed(char[] cs, int offSet, char[] ps) {
        for (int i = 0; i < ps.length; ++i) {
            int c = i + offSet;
            if (c >= cs.length) {
                return false;
            }
            if (cs[c] == ps[i] || ps[i] == '?') continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

