/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.DurationUnit;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class StringUtil {
    public static final String PROPERTY_DELIMITER = "|";
    public static final char DEFAULT_PAD_CHAR = ' ';
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$StringUtil == null ? (class$org$shiftone$jrat$util$StringUtil = StringUtil.class$("org.shiftone.jrat.util.StringUtil")) : class$org$shiftone$jrat$util$StringUtil);
    private static DateFormat dateFormat = new SimpleDateFormat("MMM d, yy  h:mm:ss:S aaa");
    private static final DurationUnit DU_MILLI_SECONDS = new DurationUnit(1L, "ms", "ms");
    private static final DurationUnit DU_SECONDS = new DurationUnit(1000L, "sec", "sec");
    private static final DurationUnit DU_MINUTES = new DurationUnit(StringUtil.DU_SECONDS.ms * 60L, "minute", "minutes");
    private static final DurationUnit DU_HOURS = new DurationUnit(StringUtil.DU_MINUTES.ms * 60L, "hour", "hours");
    private static final DurationUnit DU_DAYS = new DurationUnit(StringUtil.DU_HOURS.ms * 24L, "day", "days");
    private static final DurationUnit DU_YEARS = new DurationUnit(StringUtil.DU_DAYS.ms * 365L, "year", "years");
    private static final DurationUnit DU_DECADES = new DurationUnit(StringUtil.DU_YEARS.ms * 10L, "decade", "decades");
    private static final DurationUnit DU_CENTURIES = new DurationUnit(StringUtil.DU_DECADES.ms * 10L, "century", "centuries");
    private static final DurationUnit[] UNITS = new DurationUnit[]{DU_CENTURIES, DU_DECADES, DU_YEARS, DU_DAYS, DU_HOURS, DU_MINUTES, DU_SECONDS, DU_MILLI_SECONDS};
    private static final String[] SPACES = new String[16];
    private static final String[] ZEROS = new String[16];
    static /* synthetic */ Class class$org$shiftone$jrat$util$StringUtil;

    public static Properties parsePropertiesString(String propString) {
        Properties properties = new Properties();
        StringUtil.parsePropertiesString(propString, properties);
        return properties;
    }

    public static void parsePropertiesString(String propString, Properties properties) {
        StringTokenizer tokenizer = null;
        String token = null;
        String key = null;
        String value = null;
        Assert.assertNotNull("propString", propString);
        Assert.assertNotNull("properties", properties);
        tokenizer = new StringTokenizer(propString, PROPERTY_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            int eqIndex = token.indexOf(61);
            if (eqIndex > 0) {
                key = token.substring(0, eqIndex);
                value = token.substring(eqIndex + 1);
                properties.put(key, value);
                continue;
            }
            LOG.warn("property assignment can not be parsed from '" + token + "'");
        }
        LOG.debug(properties);
    }

    public static String bufferString(int desiredLength, char padChar) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < desiredLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String rightPad(String input, int desiredLength, char padChar) {
        Assert.assertNotNull("input string", input);
        String result = input;
        int padAmount = desiredLength - input.length();
        if (padAmount > 0) {
            result = StringUtil.bufferString(padAmount, padChar) + result;
        }
        return result;
    }

    public static String leftPad(String input, int desiredLength, char padChar) {
        Assert.assertNotNull("input string", input);
        String result = input;
        int padAmount = desiredLength - input.length();
        if (padAmount > 0) {
            result = result + StringUtil.bufferString(padAmount, padChar);
        }
        return result;
    }

    public static String rightPad(Object input, int desiredLength) {
        return StringUtil.rightPad(String.valueOf(input), desiredLength, ' ');
    }

    public static String rightPad(int input, int desiredLength) {
        return StringUtil.rightPad(String.valueOf(input), desiredLength, ' ');
    }

    public static String rightPad(long input, int desiredLength) {
        return StringUtil.rightPad(String.valueOf(input), desiredLength, ' ');
    }

    public static String leftPad(Object input, int desiredLength) {
        return StringUtil.leftPad(String.valueOf(input), desiredLength, ' ');
    }

    public static String leftPad(int input, int desiredLength) {
        return StringUtil.leftPad(String.valueOf(input), desiredLength, ' ');
    }

    public static String leftPad(long input, int desiredLength) {
        return StringUtil.leftPad(String.valueOf(input), desiredLength, ' ');
    }

    public static String[] tokenize(String str, String delim, boolean returnDelims) {
        StringTokenizer tokenizer = null;
        String[] matches = null;
        Assert.assertNotNull("string", str);
        Assert.assertNotNull("delimiter", delim);
        tokenizer = new StringTokenizer(str, delim, returnDelims);
        matches = new String[tokenizer.countTokens()];
        for (int i = 0; i < matches.length; ++i) {
            matches[i] = tokenizer.nextToken();
        }
        return matches;
    }

    public static String revision(String rev) {
        String ver = "?";
        if (rev != null && rev.startsWith("$Revision: ")) {
            ver = rev.substring(11, rev.length() - 2);
        }
        return ver;
    }

    public static String booleanToString(boolean b) {
        return b ? "yes" : "no";
    }

    public static String dateToString(long d) {
        return StringUtil.dateToString(new Date(d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date date) {
        Assert.assertNotNull("date", date);
        DateFormat dateFormat = StringUtil.dateFormat;
        synchronized (dateFormat) {
            return StringUtil.dateFormat.format(date);
        }
    }

    public static String hex(long l) {
        String s = Long.toHexString(l);
        return "0x" + ZEROS[16 - s.length()] + s.toUpperCase();
    }

    public static String hex(int i) {
        String s = Integer.toHexString(i);
        return "0x" + ZEROS[8 - s.length()] + s.toUpperCase();
    }

    public static byte[] toBytes(String value) {
        byte[] bytes = new byte[value.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)value.charAt(i);
        }
        return bytes;
    }

    public static String removeNonLetterOrDigit(String string) {
        Assert.assertNotNull("string", string);
        StringBuffer sb = new StringBuffer(string.length());
        char[] in = string.toCharArray();
        for (int i = 0; i < in.length; ++i) {
            if (!Character.isLetterOrDigit(in[i])) continue;
            sb.append(in[i]);
        }
        return sb.toString();
    }

    public static String durationToString(long duration) {
        StringBuffer sb = new StringBuffer();
        boolean match = false;
        for (int i = 0; i < UNITS.length; ++i) {
            DurationUnit du = UNITS[i];
            long units = duration / du.ms;
            if (units <= 0L) continue;
            duration -= units * du.ms;
            if (match) {
                sb.append(", ");
            }
            sb.append(units);
            sb.append(" ");
            if (units > 1L) {
                sb.append(du.pName);
            } else {
                sb.append(du.sName);
            }
            match = true;
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringUtil.ZEROS[0] = "";
        StringUtil.SPACES[0] = "";
        for (int i = 1; i < SPACES.length; ++i) {
            StringUtil.SPACES[i] = SPACES[i - 1] + " ";
            StringUtil.ZEROS[i] = ZEROS[i - 1] + "0";
        }
    }
}

