// ----------------------------------------------------------------------------------------
// Constraint propagators
// ----------------------------------------------------------------------------------------
package queso.constraints;

import java.io.*;
import java.util.*;

import queso.core.*;

public abstract class constraint
{
    final qcsp problem;           // The problem this constraint belongs to
    public int id; // The index in the constraint array of the problem.
    // Would be better to pass back an array of variable 
    constraint(qcsp problem)
    {
        this.problem=problem;        
        problem.addcons(this);
    }
    
    public abstract boolean establish();  // all the root node setup stuff, including adding itself to wakeup lists.
    
    public abstract boolean entailed();   // returns true iff the constraint is guaranteed not to fail or call exclude.
    
    void check_variables(variable_iface [] vars)
    {
        // this is incredibly dumb.
        variable [] vars2=new variable[vars.length];
        for(int i=0; i<vars.length; i++) vars2[i]=(variable)vars[i];
        check_variables(vars2);
    }
    
    // to be called with an array of variables in this constraint
    void check_variables(variable [] vars)
    {
        // sanity check
        for(int i=0; i<vars.length; i++)
        {
            assert vars[i]!=null : "Item "+i+" in variables array is null";
        }
        
        boolean all_same=true;
        for(int i=0; i<vars.length-1; i++)
        {
            if(vars[i].quant()!=vars[i+1].quant()) all_same=false;
        }
        if(all_same) return;
        
        for(int i=0; i<vars.length-1; i++)
        {
            for(int j=i+1; j<vars.length; j++)
            {
                if(vars[i].quant()!=vars[j].quant() && vars[i].blocknumber()>vars[j].blocknumber())
                {
                    System.out.println("Sanity check: Either variables in wrong order, or some not present in problem instance.");
                    for(int k=0; k<vars.length; k++)
                    {
                        System.out.println("block number "+vars[k].blocknumber());
                    }
                    System.out.println(this);
                }
            }
        }
        
        for(int i=0; i<vars.length-1; i++)
        {
            for(int j=i+1; j<vars.length; j++)
            {
                if(vars[i] == vars[j] && vars[i].quant())
                {
                    System.out.println("Warning: Two copies of the same universal variable in a constraint. This may lead to incorrect results.");
                }
            }
        }
    }
}

