package queso.constraints;

import queso.core.*;

// wrap the schema constraint such that it removes all values instead of failing.
public class gac_schema_predicate_nofail extends gac_schema_predicate
{
    public gac_schema_predicate_nofail(mid_domain [] vars, qcsp prob, predicate_wrapper pred)
    {
        super(vars, prob, pred);
    }
    
    public boolean establish()
    {
        boolean flag=super.establish();
        if(!flag)
        {
            // prune all values
            for(mid_domain md : variables)
            {
                for(int i=md.lowerbound(); i<=md.upperbound(); i++)
                    if(md.is_present(i)) 
                        md.exclude(i, this);
            }
        }
        return true;
    }
    
    public boolean propagate(int var, int val)
    {
        boolean flag=super.propagate(var,  val);
        if(!flag)
        {
            // prune all values
            for(mid_domain md : variables)
            {
                for(int i=md.lowerbound(); i<=md.upperbound(); i++)
                    if(md.is_present(i)) 
                        md.exclude(i, this);
            }
        }
        return true;
    }
}


