package queso.constraints;

import queso.core.*;

public class or_constraint_values extends or_c
{
    // this version works on an array of variables and an array of values.
    // A literal is true iff variables[var]==values[var] && !negated[var]  or  variables[var]!=values[var] && negated[var]
    
    public or_constraint_values(mid_domain [] variables, int [] values, boolean [] negated, int xi, qcsp problem)
    {
        super(variables, negated, xi, problem);
        this.values=values;
        // can't really do any sanity checks on the values array.
    }
    public final int [] values;
    
    boolean pruning(int variable, boolean value)
    {
        // prune the value from the literal
        //System.out.println("Constraint "+this+" pruning value "+value+" variable "+variables[variable]+" values[var] "+values[variable]);
        if((negated[variable] && !value) || (!negated[variable] && value))
        {
            // then prune =values[var] from the variable.
            //System.out.println("Pruning value "+values[variable]+" from dom of "+variables[variable]);
            return variables[variable].exclude(values[variable], this);
        }
        else
        {
            // prune != values[var] from the variable.
            mid_domain var=variables[variable];
            int intvalue=values[variable];
            //System.out.println("Pruning all values except "+intvalue+" from dom of "+var);
            for(int i=var.lowerbound(); i<=var.upperbound(); i++)
            {
                if(i!=intvalue && var.is_present(i))
                {
                    if(!var.exclude(i, this))
                    {
                        return false;
                    }
                }
            }
            return true;
        }
    }
    
    int litstate(int i)
    {
        // variable of index i, with negated[i], makes a literal
        // get the state of the literal
        // 0, 1, a=2 and e=3
        
        mid_domain var=variables[i];
        //System.out.println("Litstate of variable "+variables[i]);
        //System.out.println("With domain "+variables[i].domain());
        // check if the variable == values[variable].
        // First check if there are other values present.
        if(var.lowerbound()<values[i] || var.upperbound()>values[i])
        {
            if(var.is_present(values[i]))
            {   // both the value and other values are present.
                if(var.quant())
                {
                    //System.out.println("Returning 2");
                    return 2;
                }
                else
                {
                    //System.out.println("Returning 3");
                    return 3;
                }
            }
            else
            {
                if(negated[i])
                {   // not-equal and negated
                    //System.out.println("Returning 1 place 1");
                    return 1;
                }
                else
                {   // 
                    //System.out.println("Returning 0 place 1");
                    return 0;
                }
            }
        }
        
        assert var.is_present(values[i]) : "why an empty domain in a constraint propagator?";
        if(negated[i])
        {   // set to == and negated
            //System.out.println("Returning 0 place 2");
            return 0;
        }
        else
        {   //System.out.println("Returning 1 place 2");
            return 1;
        }
    }
    
    public String toString()
    {
        String st="";
        for(int i=0; i<variables.length; i++)
        {
            if(i!=xi)
            {
                st+=variables[i]+(negated[i]?"!=":"=")+values[i]+" or ";
            }
        }
        st+=" <=> "+variables[xi]+(negated[xi]?"!=":"=")+values[xi]+" " ;
        return st;
    }
}
