package queso.core;

import queso.constraints.*;

public class universal extends hash_var
{        
    public universal(int lowerbound, int upperbound, qcsp problem, String name)
    {
        super(lowerbound, upperbound, problem, true, name);
    }
    
    public universal(int numvals, qcsp problem, String name)
    {
        super(0, numvals-1, problem, true, name);
    }
    
    public universal(int lowerbound, int upperbound, int [] hash, qcsp problem, String name)
    {
        // this may not currently work correctly.
        super(lowerbound, upperbound, problem, true, name);
        assert upperbound-lowerbound+1==hash.length;
        this.hash=hash; // replacing the hash just made by the super constructor.
        // hash is expected to contain only 0's and 2's.
    }
    
    public boolean exclude(int val, constraint cons)
    {
        // Pruning from a universal is not allowed
        if(problem.pruning) System.out.println("Attempted to prune universal "+this);
        return false;
    }
    
    public boolean exclude_upper(int val, constraint cons)
    {
        // val is the new upper bound
        assert val<upperbound;
        if(problem.pruning) System.out.println("Attempted to prune universal "+this);
        return false;
    }
    
    public boolean exclude_lower(int val, constraint cons)
    {
        // val is the new lower bound
        assert val>lowerbound;
        if(problem.pruning) System.out.println("Attempted to prune universal "+this);
        return false;
    }
    
    // weights support
    
    int [] weights;
    
    public void setweights(int [] weights)
    {
        this.weights=weights;
        assert weights.length==this.domsize();
    }
    
    public int getweight(int value)
    {
        return weights[value+this.offset()];
    }
    
    public boolean pure(int val, constraint cons)
    {
        // This function is used to remove subsumed values 
        if(problem.pruning) System.out.println("Pruning (pure) var "+this+" val "+val);
        //System.out.println("Pruning (pure) var "+this+" val "+val);
        assert is_present(val);  // this should probably be changed to a return false.
        
        remove_nofail(val);
        
        if(is_present(val) && problem.pruning) System.out.println("Value not actually removed.");
        
        // Check the wakeups array here -- maybe. WHY? no point revising constraints for a pure value.
        if(!is_present(val))
        {
            for(constraint temp : wakeups_anychange)
            {
                //System.out.println("Adding constraint:");
                //System.out.println(temp);
                if(temp!=cons)
                {
                if(temp instanceof fd_propagate)
                    problem.queue.push_constraint((fd_propagate)temp, id, val);
                else
                    problem.queue.push_constraint((make_ac)temp);
                }
            }
        }
        return true;
    }
    
    public boolean instantiate(int val)
    {
        // set var=val
        //System.out.println("Setting "+name+" to "+val);
        assert is_present(val);
        
        //exclude all other values
        for(int i=lowerbound; i<=upperbound; i++)
        {
            if(is_present(i) && i!=val)
            {
                boolean temp=remove(i);
                assert temp;
                
                for(constraint cons : wakeups_anychange)
                {
                    //System.out.println("Adding constraint:");
                    //System.out.println(temp);
                    
                    if(cons instanceof fd_propagate)
                        problem.queue.push_constraint((fd_propagate)cons, id, i);
                    else
                        problem.queue.push_constraint((make_ac)cons); // could optimize here.
                    
                }
            }
        }
        return true;
    }
}
