package queso.experiments;

import java.util.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;

class connectfourboard1
{
    public static void main(String [] args)
    {
        qcsp prob = new qcsp();
        stopwatch sw= new stopwatch("GMT");
        
        mid_domain[] moves=new mid_domain[5];
        
        moves[0]=new existential(7, prob, "omove1");
        moves[1]=new universal(7, prob, "xmove1");
        moves[2]=new existential(7, prob, "omove2");
        moves[3]=new universal(7, prob, "xmove2");
        moves[4]=new existential(7, prob, "omove3");
        
        cfourpred p1=new cfourpred();
        
        gac_schema_predicate cons= new gac_schema_predicate(moves, prob, p1);
        
        sw.start();
        cons.establish();
        sw.end();
        
        System.out.println(sw.elapsedMillis());
        prob.printdomains();
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[0].exclude(1, null);
        
        sw.start();
        prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis());
        
        prob.printdomains();
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[1].exclude(0, null);moves[1].exclude(1, null);moves[1].exclude(2, null);
        moves[1].exclude(4, null);moves[1].exclude(5, null);moves[1].exclude(6, null);
        
        sw.start();
        prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis());
        
        //System.out.println(cons);
        
        prob.printdomains();
        //System.out.println(cons);
    }
}

class connectfourboard1sqgac
{
    public static void main(String [] args)
    {
        qcsp prob = new qcsp();
        stopwatch sw= new stopwatch("GMT");
        
        mid_domain[] moves=new mid_domain[5];
        
        moves[0]=new existential(7, prob, "omove1");
        moves[1]=new universal(7, prob, "xmove1");
        moves[2]=new existential(7, prob, "omove2");
        moves[3]=new universal(7, prob, "xmove2");
        moves[4]=new existential(7, prob, "omove3");
        
        cfourpred p1=new cfourpred();
        
        sqgac cons= new sqgac(moves, prob, p1);
        
        sw.start();
        cons.establish();
        sw.end();
        
        System.out.println(sw.elapsedMillis());
        prob.printdomains();
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[0].exclude(1, null);
        
        sw.start();
        boolean flag=prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        
        prob.printdomains();
        
        try
        {
        File output = new File("sqgac_test.dot");
        
        FileWriter out = new FileWriter(output);
        out.write(cons.printtree_alt());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing sqgac_test.dot");
        }
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[1].instantiate(3);
        
        sw.start();
        flag=prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        
        //System.out.println(cons);
        
        prob.printdomains();
        //System.out.println(cons);
    }
}

class cfourpred implements predicate_wrapper
{
    final boolean record=false;
    int numinvocations=0;
    
    // diagram 1.
    // Two ways to win.
    
    // board state, 0 equals o and 1=x. 2=unoccupied.
    
    // board[row][column] = state
    
    public boolean predicate(tuple tau)
    {
        // tau[0] is omove1   in 0..6
        // tau[1] is xmove1
        // tau[2] is omove2
        // tau[3] is xmove2
        // tau[4] is omove3
        if(record){ numinvocations++;System.out.println("invocations:"+numinvocations);}
        
        int [][] board={{2,2,2,2,2,2,2},
                        {2,2,2,2,2,2,2},
                        {2,2,1,2,2,1,2},
                        {2,2,1,2,0,1,2},
                        {0,2,0,0,1,0,1},
                        {1,2,0,1,1,0,0}
                        };
        
        int[] vals=tau.vals;
        
        // first move, o
        boolean flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[0]]==2)
            {
                board[i][vals[0]]=0;
                flag=true;
                break;
            }
        }
        //System.out.println("After first move");
        //printboard();
        if(!flag) return false;
        if(checklines(board))
        {
            return true;
        }
        
        // first move, x
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[1]]==2)
            {
                board[i][vals[1]]=1;
                flag=true;
                break;
            }
        }
        if(!flag) return true;
        if(checklines(board))
        {
            return false;
        }
        //System.out.println("After second move");
        //printboard();
        
        // second move, o
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[2]]==2)
            {
                board[i][vals[2]]=0;
                flag=true;
                break;
            }
        }
        if(!flag) return false;
        if(checklines(board))
        {
            return true;
        }
        //System.out.println("After third move");
        //printboard();
        // second move, x
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[3]]==2)
            {
                board[i][vals[3]]=1;
                flag=true;
                break;
            }
        }
        if(!flag) return true;
        if(checklines(board))
        {
            return false;
        }
        //System.out.println("After fourth move");
        //printboard();
        // third move, o
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[4]]==2)
            {
                board[i][vals[4]]=0;
                flag=true;
                break;
            }
        }
        if(!flag) return false;
        if(checklines(board))
        {
            return true;
        }
        //System.out.println("After fifth move");
        //printboard(board);
        // third move,
        // draw
        return false;
    }
    
    
    // return true for a line.
    boolean checklines(int [][] board)
    {
        // horizontal lines
        for(int row=0; row<6; row++)
        {
            for(int col=0; col<4; col++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row][col+1]==0 && board[row][col+2]==0 && board[row][col+3]==0)
                || (board[row][col]==1 && board[row][col+1]==1 && board[row][col+2]==1 && board[row][col+3]==1))
                    return true;
            }
        }
        
        // vertical lines
        for(int col=0; col<7; col++)
        {
            for(int row=0; row<3; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row+1][col]==0 && board[row+2][col]==0 && board[row+3][col]==0)
                || (board[row][col]==1 && board[row+1][col]==1 && board[row+2][col]==1 && board[row+3][col]==1))
                    return true;
            }
        }
        
        // down diagonals
        for(int col=0; col<4; col++)
        {
            for(int row=0; row<3; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row+1][col+1]==0 && board[row+2][col+2]==0 && board[row+3][col+3]==0)
                || (board[row][col]==1 && board[row+1][col+1]==1 && board[row+2][col+2]==1 && board[row+3][col+3]==1))
                    return true;
            }
        }
        
        // up diagonals
        for(int col=0; col<4; col++)
        {
            for(int row=3; row<6; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row-1][col+1]==0 && board[row-2][col+2]==0 && board[row-3][col+3]==0)
                || (board[row][col]==1 && board[row-1][col+1]==1 && board[row-2][col+2]==1 && board[row-3][col+3]==1))
                    return true;
            }
        }
        return false;
    }
    
    void printboard(int [][] board)
    {
        for(int row=0; row<6; row++)
        {
            for(int col=0; col<7; col++)
            {
                System.out.print(board[row][col]+" | ");
            }
            System.out.println();
        }
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

class connectfourboard2   //equals diagram 3
{
    public static void main(String [] args)
    {
        qcsp prob = new qcsp();
        stopwatch sw= new stopwatch("GMT");
        
        mid_domain[] moves=new mid_domain[7];
        
        moves[0]=new existential(7, prob, "omove1");
        moves[1]=new universal(7, prob, "xmove1");
        moves[2]=new existential(7, prob, "omove2");
        moves[3]=new universal(7, prob, "xmove2");
        moves[4]=new existential(7, prob, "omove3");
        moves[5]=new universal(7, prob, "xmove3");
        moves[6]=new existential(7, prob, "omove4");
        
        cfourpred2 p1=new cfourpred2();
        gac_schema_predicate cons= new gac_schema_predicate(moves, prob, p1);
        
        sw.start();
        boolean flag=cons.establish();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        prob.printdomains();
        //System.out.println(cons);
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[0].instantiate(3);
        
        sw.start();
         flag=prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        
        prob.printdomains();
        
        
        
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[1].instantiate(3);
        
        sw.start();
         flag=prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        prob.printdomains();
        
        
        
        //System.out.println(cons);
    }
}

class connectfourboard2sqgac   //equals diagram 3
{
    public static void main(String [] args)
    {
        qcsp prob = new qcsp();
        stopwatch sw= new stopwatch("GMT");
        
        mid_domain[] moves=new mid_domain[7];
        
        moves[0]=new existential(7, prob, "omove1");
        moves[1]=new universal(7, prob, "xmove1");
        moves[2]=new existential(7, prob, "omove2");
        moves[3]=new universal(7, prob, "xmove2");
        moves[4]=new existential(7, prob, "omove3");
        moves[5]=new universal(7, prob, "xmove3");
        moves[6]=new existential(7, prob, "omove4");
        
        cfourpred2 p1=new cfourpred2();
        sqgac cons= new sqgac(moves, prob, p1);
        
        sw.start();
        boolean flag=cons.establish();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        prob.printdomains();
        //System.out.println(cons);
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[0].instantiate(3);
        
        sw.start();
         flag=prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        
        prob.printdomains();
        
        
        
        
        sw= new stopwatch("GMT");
        
        prob.add_backtrack_level();
        
        moves[1].instantiate(3);
        
        sw.start();
         flag=prob.propagate();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        prob.printdomains();
        
        
        
        //System.out.println(cons);
    }
}

class connectfourboard3  // equals diagram 1.
{
    public static void main(String [] args)
    {
        qcsp prob = new qcsp();
        stopwatch sw= new stopwatch("GMT");
        
        mid_domain[] moves=new mid_domain[3];
        
        moves[0]=new existential(7, prob, "omove1");
        moves[1]=new universal(7, prob, "xmove1");
        moves[2]=new existential(7, prob, "omove2");
        
        cfourpred3 p1=new cfourpred3();
        gac_schema_predicate cons= new gac_schema_predicate(moves, prob, p1);
        
        sw.start();
        boolean flag=cons.establish();
        sw.end();
        
        System.out.println(sw.elapsedMillis()+":"+flag);
        prob.printdomains();
        //System.out.println(cons);
        
    }
}

class connectfourtest
{
    public static void main(String [] args)
    {
        cfourpred p1=new cfourpred();
        int[] t={4,6,0,1,0};
        tuple tau=new tuple(t);
        System.out.println(p1.predicate(tau));
    }
}

class cfourpred2 implements predicate_wrapper
{
    final boolean record=false;
    int numinvocations=0;
    
    final boolean print=false;
    
    // diagram 1.
    // Two ways to win.
    
    // board state, 0 equals o and 1=x. 2=unoccupied.
    
    // board[row][column] = state
    
    public boolean predicate(tuple tau)
    {
        // tau[0] is omove1   in 0..6
        // tau[1] is xmove1
        // tau[2] is omove2
        // tau[3] is xmove2
        // tau[4] is omove3
        // tau[5] is xmove2
        // tau[6] is omove3
        
        assert tau.vals.length==7;
        
        if(record){ numinvocations++; System.out.println("invocations:"+numinvocations);}
        
        /*int [][] board={{2,2,2,2,2,2,2},
                    {2,2,2,2,2,2,2},
                    {2,2,1,2,2,1,2},
                    {2,2,1,2,0,1,2},
                    {0,2,0,0,1,0,1},
                    {1,2,0,1,1,0,0}
                    };*/
        
        int [][] board={{2,2,2,2,2,1,2},
                        {2,2,1,2,2,1,2},
                        {2,2,1,2,0,1,2},
                        {2,2,0,0,1,0,1},
                        {1,2,1,0,1,0,0},
                        {0,0,1,1,0,1,0}
                        };
        
        
        int[] vals=tau.vals;
        
        // first move, o
        
        boolean flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[0]]==2)
            {
                board[i][vals[0]]=0;
                flag=true;
                break;
            }
        }
        
        if(!flag) return false;  // o cheats
        
        if(checklines(board))
        {
            if(print)
            {
            System.out.println("True:");
            printboard(board);
            }
            return true;
        }
        
        // first move, x
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[1]]==2)
            {
                board[i][vals[1]]=1;
                flag=true;
                break;
            }
        }
        
        if(!flag) return true;   // x cheats
        
        if(checklines(board))
        {
            return false;
        }
        
        // second move, o
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[2]]==2)
            {
                board[i][vals[2]]=0;
                flag=true;
                break;
            }
        }
        
        if(!flag) return false;
        
        if(checklines(board))
        {
            if(print)
            {
            System.out.println("True:");
            printboard(board);
            }
            return true;
        }
        
        // second move, x
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[3]]==2)
            {
                board[i][vals[3]]=1;
                flag=true;
                break;
            }
        }
        
        if(!flag) return true; 
        
        if(checklines(board))
        {    
            return false;
        }
        
        // third move, o
        flag=false;
        
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[4]]==2)
            {
                board[i][vals[4]]=0;
                flag=true;
                break;
            }
        }
        
        if(!flag) return false;
        
        if(checklines(board))
        {
            if(print)
            {
            System.out.println("True:");
            printboard(board);
            }
            return true;
        }
        
        // third move, x
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[5]]==2)
            {
                board[i][vals[5]]=1;
                flag=true;
                break;
            }
        }
        
        if(!flag) return true;
        
        if(checklines(board))
        {
            return false;
        }
        
        // fourth move, o
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[6]]==2)
            {
                board[i][vals[6]]=0;
                flag=true;
                break;
            }
        }
        if(!flag) return false;
        
        if(checklines(board))
        {
            if(print)
            {
            System.out.println("True:");
            printboard(board);
            }
            return true;
        }
        
        // third move,
        // draw
        return false;
    }
    
    
    // return true for a line.
    boolean checklines(int [][] board)
    {
        // horizontal lines
        for(int row=0; row<6; row++)
        {
            for(int col=0; col<4; col++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row][col+1]==0 && board[row][col+2]==0 && board[row][col+3]==0)
                || (board[row][col]==1 && board[row][col+1]==1 && board[row][col+2]==1 && board[row][col+3]==1))
                    return true;
            }
        }
        
        // vertical lines
        for(int col=0; col<7; col++)
        {
            for(int row=0; row<3; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row+1][col]==0 && board[row+2][col]==0 && board[row+3][col]==0)
                || (board[row][col]==1 && board[row+1][col]==1 && board[row+2][col]==1 && board[row+3][col]==1))
                    return true;
            }
        }
        
        // down diagonals
        for(int col=0; col<4; col++)
        {
            for(int row=0; row<3; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row+1][col+1]==0 && board[row+2][col+2]==0 && board[row+3][col+3]==0)
                || (board[row][col]==1 && board[row+1][col+1]==1 && board[row+2][col+2]==1 && board[row+3][col+3]==1))
                    return true;
            }
        }
        
        // up diagonals
        for(int col=0; col<4; col++)
        {
            for(int row=3; row<6; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row-1][col+1]==0 && board[row-2][col+2]==0 && board[row-3][col+3]==0)
                || (board[row][col]==1 && board[row-1][col+1]==1 && board[row-2][col+2]==1 && board[row-3][col+3]==1))
                    return true;
            }
        }
        return false;
    }
    
    void printboard(int [][] board)
    {
        for(int row=0; row<6; row++)
        {
            for(int col=0; col<7; col++)
            {
                System.out.print(board[row][col]+" | ");
            }
            System.out.println();
        }
    }
}

class cfourpred3 implements predicate_wrapper
{
    final boolean record=true;
    int numinvocations=0;
    
    final boolean print=false;
    
    // diagram 1.
    // Two ways to win.
    
    // board state, 0 equals o and 1=x. 2=unoccupied.
    
    // board[row][column] = state
    
    public boolean predicate(tuple tau)
    {
        // tau[0] is omove1   in 0..6
        // tau[1] is xmove1
        // tau[2] is omove2
        
        assert tau.vals.length==3;
        
        if(record){numinvocations++; System.out.println("invocations:"+numinvocations);}
        
        /*int [][] board={{2,2,2,2,2,2,2},
                    {2,2,2,2,2,2,2},
                    {2,2,1,2,2,1,2},
                    {2,2,1,2,0,1,2},
                    {0,2,0,0,1,0,1},
                    {1,2,0,1,1,0,0}
                    };*/
        
        int [][] board={{2,2,2,2,2,2,2},
                        {2,2,2,2,2,2,2},
                        {2,2,0,1,2,2,2},
                        {2,2,1,0,1,2,2},
                        {0,2,0,0,1,0,2},
                        {1,2,0,1,0,1,1}
                        };
        
        int[] vals=tau.vals;
        
        // first move, o
        boolean flag=false;
        
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[0]]==2)
            {
                board[i][vals[0]]=0;
                flag=true;
                break;
            }
        }
        if(!flag) return false;
        if(checklines(board))
        {
            if(print)
            {
            System.out.println("True:");
            printboard(board);
            }
            return true;
        }
        
        // first move, x
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[1]]==2)
            {
                board[i][vals[1]]=1;
                flag=true;
                break;
            }
        }
        if(!flag) return true;
        
        if(checklines(board))
        {
            return false;
        }
        
        // second move, o
        flag=false;
        for(int i=5; i>=0; i--)
        {
            if(board[i][vals[2]]==2)
            {
                board[i][vals[2]]=0;
                flag=true;
                break;
            }
        }
        if(!flag) return false;
        if(checklines(board))
        {
            if(print)
            {
            System.out.println("True:");
            printboard(board);
            }
            return true;
        }
        
        
        // draw
        return false;
    }
    
    
    // return true for a line.
    boolean checklines(int [][] board)
    {
        // horizontal lines
        for(int row=0; row<6; row++)
        {
            for(int col=0; col<4; col++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row][col+1]==0 && board[row][col+2]==0 && board[row][col+3]==0)
                || (board[row][col]==1 && board[row][col+1]==1 && board[row][col+2]==1 && board[row][col+3]==1))
                    return true;
            }
        }
        
        // vertical lines
        for(int col=0; col<7; col++)
        {
            for(int row=0; row<3; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row+1][col]==0 && board[row+2][col]==0 && board[row+3][col]==0)
                || (board[row][col]==1 && board[row+1][col]==1 && board[row+2][col]==1 && board[row+3][col]==1))
                    return true;
            }
        }
        
        // down diagonals
        for(int col=0; col<4; col++)
        {
            for(int row=0; row<3; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row+1][col+1]==0 && board[row+2][col+2]==0 && board[row+3][col+3]==0)
                || (board[row][col]==1 && board[row+1][col+1]==1 && board[row+2][col+2]==1 && board[row+3][col+3]==1))
                    return true;
            }
        }
        
        // up diagonals
        for(int col=0; col<4; col++)
        {
            for(int row=3; row<6; row++)
            {
                // col is starting column
                if( (board[row][col]==0 && board[row-1][col+1]==0 && board[row-2][col+2]==0 && board[row-3][col+3]==0)
                || (board[row][col]==1 && board[row-1][col+1]==1 && board[row-2][col+2]==1 && board[row-3][col+3]==1))
                    return true;
            }
        }
        return false;
    }
    
    void printboard(int [][] board)
    {
        for(int row=0; row<6; row++)
        {
            for(int col=0; col<7; col++)
            {
                System.out.print(board[row][col]+" | ");
            }
            System.out.println();
        }
    }
}

