package queso.experiments;

import java.util.*;
import java.math.*;
import java.lang.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;
import queso.encoding.*;

class ijcai07ex1
{
    public static void main(String [] args)
    {
        ijcai07ex1 ex;
        Ctype c;
        for(density=0.2; density<=0.8; density=density+0.3)
        { //density=0.8;
        
        c=Ctype.reginlhomme;
        ex=new ijcai07ex1();
        
        System.out.println("Regin-Lhomme");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new ijcai07ex1();
        
        System.out.println("Nightingale one list");
        ex.runbunch(c);
        
        if(density!=0.8)
        {
            c=Ctype.simplebacktrack;
            ex=new ijcai07ex1();
            
            System.out.println("Simple with backtracking");
            ex.runbunch(c);
        }
        
        c=Ctype.trie;
        ex=new ijcai07ex1();
        
        System.out.println("Trie");
        ex.runbunch(c);
        
        c=Ctype.simple;
        ex=new ijcai07ex1();
        
        System.out.println("Simple");
        ex.runbunch(c);
        
        // last because it is liable to run out of mem.
        c=Ctype.nightingale;
        ex=new ijcai07ex1();
        
        System.out.println("Nightingale");
        ex.runbunch(c);
        
        // Minion experiments
        
        /*c=Ctype.minionsimple;
        ex=new ijcai07ex1();
        ex.r=new Random(12345);
        System.out.println("Minion Simple");
        ex.runbunch(c);
        
        c=Ctype.minionrl;
        ex=new ijcai07ex1();
        ex.r=new Random(12345);
        System.out.println("Minion Regin-Lhomme");
        ex.runbunch(c);
        
        c=Ctype.minionn;
        ex=new ijcai07ex1();
        ex.r=new Random(12345);
        System.out.println("Minion nightingale");
        ex.runbunch(c);
        
        c=Ctype.minionnone;
        ex=new ijcai07ex1();
        ex.r=new Random(12345);
        System.out.println("Minion nightingale one list");
        ex.runbunch(c);
        
        c=Ctype.miniontrie;
        ex=new ijcai07ex1();
        ex.r=new Random(12345);
        System.out.println("Minion trie");
        ex.runbunch(c);*/
        }
    }
    
    void runbunch(Ctype c)
    {
        // first of all, run the arity 5 experiment as a warmup. Should be overkill.
        r=new Random(12345);
        runarity(5, c);
        
        r=new Random(12345);
        // Now run the whole range of parameters
        for(int arity=5; arity<=11; arity=arity+2)
        {
            runarity(arity, c);
        }
    }
    
    public void runarity(int arity, Ctype c)
    {
        System.out.println("arity:"+arity);
        for(int d=2; d<=5; d++)
        {
            int numvars;
            if(d==2) numvars=25;
            else if(d==3) numvars=13;
            else if(d==4) numvars=8;
            else numvars=7; // d==5
            
            if(arity==7) numvars--;
            else if(arity==9) numvars=numvars-2;
            else if(arity==11) numvars=numvars-3;
            
            if(density==0.8) numvars=numvars-2;  // make it a bit easier
            
            if(arity>numvars) break;
            
            if(arity==7 && d>=5) break;
            if(arity==9 && d>=4) break;
            if(arity==11 && d>=3) break;
            
            for(int numcons=((density==0.8)? 30:1); numcons<=100; numcons=numcons+1)
            {
                long time=0;
                long snstimelocal=0;
                long snscountlocal=0;
                int numsat=0;
                int tries=(density==0.2)?50:20;
                for(int i=0; i<tries; i++)
                {
                    time+=runtest(d, c, arity, numcons, numvars,i);
                    snstimelocal+=snstime;
                    snscountlocal+=snscount;
                    numsat+=(ifsat?1:0);
                }
                System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" time for seekns:"+snstimelocal+" snscount:"+snscountlocal+" numsat:"+numsat+"/"+tries);
                if(numsat<=(tries/4)) break;  // below the quartile, stop.
            }
        }
    }
    
    Random r; // random number generator.
    stopwatch2 sw;
    
    static double density;
    
    // returns from the runtest method.
    long snstime;
    long snscount;
    //long domainchecks;
    boolean ifsat=false;
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars, int instance)
    {
        sw=new stopwatch2();
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp(false, false, false, false, false, false, false);
        
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            vars[i]=new existential(d, prob, "x"+i);  // d for domain size.
        }
        StringBuffer sb=new StringBuffer();
        if(c==Ctype.miniontrie || c==Ctype.minionn || c==Ctype.minionnone || c==Ctype.minionsimple || c==Ctype.minionrl)
        {
            printminionheader(sb, numvars, numcons, arity, d, density);
        }
        
        // gen  constraints.
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=new mid_domain[arity];
            int counter=0;
            while(counter<arity)
            {
                int varIndex=(int) Math.floor(r.nextFloat()*numvars);
                if(!tuples.in(gsvars, vars[varIndex]))
                {
                    gsvars[counter]=vars[varIndex];
                    counter++;
                }
            }
            //int [][] tab=tuples.generateprobability(arity, gsvars, r, (float) density);
            int [][] tab=tuples.generatetuples(arity, gsvars, r, Math.round((float) (density* Math.pow((double)d, (double)arity ))));
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.reginlhomme)
            {
                new reginlhomme(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingale)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingaleOneList)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone(), false, true);
            }
            else if(c==Ctype.simple)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone(), true, false);
            }
            else if(c==Ctype.trie)
            {
                new trieconstraint(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.simplebacktrack)
            {
                new gac_schema_positive(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.miniontrie || c==Ctype.minionn || c==Ctype.minionnone || c==Ctype.minionsimple || c==Ctype.minionrl)
            {
                printminionconstraint(sb, gsvars, tab);
            }
        }
        
        System.gc();  // attempt to stop it gc'ing during the run.
        if(c==Ctype.miniontrie || c==Ctype.minionn || c==Ctype.minionnone || c==Ctype.minionsimple || c==Ctype.minionrl)
        {
        try
        {
            File output = new File("myinstance.minion");
            FileWriter out = new FileWriter(output);
            out.write(sb.toString());
            out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing myinstance.minion");
        }
        
        // and again somewhere else
        try
        {
            File output = new File("mininstances/looseness"+density+"-r"+arity+"-d"+d+"-n"+numvars+"-e"+numcons+"-instance"+instance+".minion");
            FileWriter out = new FileWriter(output);
            out.write(sb.toString());
            out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing myinstance.minion");
        }
        sw.zero();
        
        Process p=null;
        sw.start();
        try
        {
            if(c==Ctype.miniontrie)
                p = Runtime.getRuntime().exec("/home/pn/bin/minion-tries.exe myinstance.minion");
            else if(c==Ctype.minionn)
                p = Runtime.getRuntime().exec("/home/pn/bin/minion-nightingale.exe myinstance.minion");
            else if(c==Ctype.minionnone)
                p = Runtime.getRuntime().exec("/home/pn/bin/minion-nightingaleone.exe myinstance.minion");
            else if(c==Ctype.minionrl)
                p = Runtime.getRuntime().exec("/home/pn/bin/minion-reginlhomme.exe myinstance.minion");
            else if(c==Ctype.minionsimple)
                p = Runtime.getRuntime().exec("/home/pn/bin/minion-table.exe myinstance.minion");
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem running solver");
        }
        
        try
        {
            int retval=p.waitFor();
            assert retval==0;
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem waiting");
        } 
        sw.end();
        return sw.elapsedMicros();
        }
        
        sw.zero();
        stopwatch swbackup=new stopwatch();
        swbackup.start();
        sw.start();
        //prob.establish();
        //sw.end();
        
        //System.out.println("Establish time: "+sw.elapsedMillis());
        //prob.printdomains();
        //sw.start();
        
        ifsat=prob.search();
        
        //System.out.println("Sat:"+ifsat);
        sw.end();
        swbackup.end();
        snstime=0;
        snscount=0;
        for(constraint cons : prob.constraints)
        {
            if(((gac_schema)cons).sw!=null){ 
            snstime+=((gac_schema)cons).sw.elapsedMicros();
            snscount+=((gac_schema)cons).snscount;
            }
        }
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMicros();
        //return swbackup.elapsedMillis()*1000;
    }
    
    void printminionheader(StringBuffer sb, int n, int e, int r, int d, double density)
    {
        sb.append("MINION 1\n");
        sb.append("# n="+n+" e="+e+" r="+r+" d="+d+" density="+density+"\n");
        //sb.append(""+n+"\n");
        sb.append("0\n0\n0\n"+n+"\n"+"0 "+(d-1)+" "+n+"\n"); // describe variables. all 0..d-1
        sb.append("0\n["); for(int i=0; i<n-1; i++){ sb.append("x"+i+","); } sb.append("x"+(n-1)+"]\n");
        sb.append("["); for(int i=0; i<n-1; i++){ sb.append("a,"); } sb.append("a]\n");
        sb.append("0\n1\n[["); for(int i=0; i<n-1; i++) { sb.append("x"+i+","); } sb.append("x"+(n-1)+"]]\n0\n");
        sb.append("objective none\n");
        sb.append("print m0\n");
    }
    
    void printminionconstraint(StringBuffer sb, mid_domain [] gsvars, int [][] table)
    {
        sb.append("table(["); for(int i=0; i<gsvars.length; i++){ sb.append("x"+gsvars[i].id()+",");} sb.deleteCharAt(sb.length()-1); 
        sb.append("],\n{");
        for(int i=0; i<table.length; i++)
        {
            sb.append("<");
            for(int j=0; j<table[i].length; j++)
            {
                sb.append(table[i][j]);
                if(j!=table[i].length-1) sb.append(",");
            }
            sb.append(">,\n");
        }
        sb.deleteCharAt(sb.length()-1);sb.deleteCharAt(sb.length()-1);
        sb.append("})\n");
    }
}

class ijcai07ex1_minion extends ijcai07ex1
{
    // output the instances for minion.
    
    public static void main(String [] args)
    {
        ijcai07ex1_minion ex;
        Ctype c;
        for(density=0.2; density<=0.8; density=density+0.3)
        { //density=0.8;
        
        c=Ctype.miniontrie;
        ex=new ijcai07ex1_minion();
        System.out.println("Minion Output");
        ex.runbunch(c);
        
        }
    }
    
    public void runarity(int arity, Ctype c)
    {
        System.out.println("Using modified runarity. arity:"+arity);
        for(int d=2; d<=5; d++)
        {
            int numvars;
            if(d==2) numvars=25;
            else if(d==3) numvars=13;
            else if(d==4) numvars=8;
            else numvars=7; // d==5
            
            if(arity==7) numvars--;
            else if(arity==9) numvars=numvars-2;
            else if(arity==11) numvars=numvars-3;
            
            if(density==0.8) numvars=numvars-2;  // make it a bit easier
            
            if(arity>numvars) break;
            
            if(arity==7 && d>=5) break;
            if(arity==9 && d>=4) break;
            if(arity==11 && d>=3) break;
            
            for(int numcons=((density==0.8)? 30:1); numcons<=100; numcons=numcons+1)
            {
                long time=0;
                long snstimelocal=0;
                long snscountlocal=0;
                int numsat=0;
                int tries=(density==0.2)?50:20;
                for(int i=0; i<tries; i++)
                {
                    time+=runtest(d, c, arity, numcons, numvars,i);
                    snstimelocal+=snstime;
                    snscountlocal+=snscount;
                    numsat+=(ifsat?1:0);
                }
                System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" time for seekns:"+snstimelocal+" snscount:"+snscountlocal+" numsat:"+numsat+"/"+tries);
                
                if(density==0.2 && numcons>11) break;  // below the quartile, stop.
                if(density==0.5 && numcons>26) break;
                if(density==0.8 && numcons>76) break;
            }
        }
    }
}

class ijcai07ex2
{
    // just initialization on problems that contain a single constraint.
    // Remember density is lower here!
    public static void main(String [] args)
    {
        Ctype c=Ctype.reginlhomme;
        ijcai07ex2 ex=new ijcai07ex2();
        ex.r=new Random(12345);
        System.out.println(c);
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new ijcai07ex2();
        ex.r=new Random(12345);
        System.out.println("Nightingale");
        ex.runbunch(c);
        
        c=Ctype.trie;
        ex=new ijcai07ex2();
        ex.r=new Random(12345);
        System.out.println("Trie");
        ex.runbunch(c);
        
        c=Ctype.simple;
        ex=new ijcai07ex2();
        ex.r=new Random(12345);
        System.out.println("Simple");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new ijcai07ex2();
        ex.r=new Random(12345);
        System.out.println("Nightingale one list");
        ex.runbunch(c);
    }
    
    void runbunch(Ctype c)
    {
        //for(int arity=10; arity<=20; arity=arity+2)
        {int arity=6;
        System.out.println("arity:"+arity);
        //for(int d=2; d<=10; d++)
        {int d=14;
        int numvars=arity;
        int numcons=1;
        //if(((int) java.lang.Math.pow(d, arity))>5000000) break;
        
        long time=0;
        int numsat=0;
        int tries=1;
        time+=runtest(d, c, arity, numcons, numvars);
        numsat+=(ifsat?1:0);
        System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+"time for suite:"+time+" numsat:"+numsat+"/"+tries);
        }
        }
    }
    
    Random r; // random number generator.
    stopwatch sw;
    
    boolean ifsat=false;
    int totalnodes=0;
    long snstime=0;
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars)
    {
        sw=new stopwatch("GMT");
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp();
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            vars[i]=new existential(d, prob, "x"+i);  // d for domain size.
        }
        
        // gen constraints.
        
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=vars;
            sw.start();
            int [][] tab=tuples.generateprobability(arity, gsvars, r, (float) 0.1);
            sw.end();
            //System.out.println("Generating tuples took "+sw.elapsedMillis());
            
            sw.start();  // this also zeroes I think.
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.reginlhomme)
            {
                new reginlhomme(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingale)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingaleOneList)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone(), false, true);
            }
            else if(c==Ctype.simple)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone(), true, false);
            }
            else if(c==Ctype.trie)
            {
                new trieconstraint(gsvars, prob, (int [][])tab.clone());
            }
            sw.end();
            System.out.println("Building table or trie took "+sw.elapsedMillis());
        }
        
        sw.start();
        prob.establish();
        
        //ifsat=prob.search();
        sw.end();
        prob.printdomains();
        //System.out.println("Sat:"+ifsat);
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMillis();//+(int)sw.elapsedMillis();
    }
}


class ijcai07ex3
{
    // duplicate the second experiment by regin lhomme. Because the third experiment does not report the number of variables!!!!
   public static void main(String [] args)
    {
        runit();
        runit();
    }
    
    static void runit()
    {
        ijcai07ex3 ex;
        Ctype c;
        //for(density=0.2; density<=0.8; density=density+0.3)
        {density=0.0286102294; numtuples=30000;
        System.out.println("Density:"+density);
        c=Ctype.reginlhomme;
        ex=new ijcai07ex3();
        ex.r=new Random(12345);
        System.out.println("Regin-Lhomme");
        ex.runbunch(c);
        
        c=Ctype.nightingale;
        ex=new ijcai07ex3();
        ex.r=new Random(12345);
        System.out.println("Nightingale");
        ex.runbunch(c);
        
        c=Ctype.trie;
        ex=new ijcai07ex3();
        ex.r=new Random(12345);
        System.out.println("Trie");
        ex.runbunch(c);
        
        c=Ctype.simple;
        ex=new ijcai07ex3();
        ex.r=new Random(12345);
        System.out.println("Simple");
        ex.runbunch(c);
        
        c=Ctype.nightingaleOneList;
        ex=new ijcai07ex3();
        ex.r=new Random(12345);
        System.out.println("Nightingale one list");
        ex.runbunch(c);
        
        c=Ctype.simplebacktrack;
        ex=new ijcai07ex3();
        ex.r=new Random(12345);
        System.out.println("Simple with backtracking pointers");
        ex.runbunch(c);
        }
    }
    
    void runbunch(Ctype c)
    {
        int arity=20;
        int d=2;
        int numvars=40;
        
        for(int numcons=1; numcons<=5; numcons=numcons+1)
        {
            long time=0;
            long snstimelocal=0;
            long snscountlocal=0;
            int numsat=0;
            int tries=1;
            for(int i=0; i<tries; i++){
                time+=runtest(d, c, arity, numcons, numvars);
                snstimelocal+=snstime;
                snscountlocal+=snscount;
                numsat+=(ifsat?1:0);
            }
            System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" time for seekns:"+snstimelocal+" snscount:"+snscountlocal+" numsat:"+numsat+"/"+tries);
            if(numsat<=(tries/4)) break;  // below the quartile, stop.
        }
    }
    
    Random r; // random number generator.
    stopwatch2 sw;
    
    static double density;
    static int numtuples;
    
    // returns from the runtest method.
    long snstime;
    long snscount;
    //long domainchecks;
    boolean ifsat=false;
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars)
    {
        sw=new stopwatch2();
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp();
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            vars[i]=new existential(d, prob, "x"+i);  // d for domain size.
        }
        
        // gen  constraints.
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=new mid_domain[arity];
            int counter=0;
            while(counter<arity)
            {
                int varIndex=(int) Math.floor(r.nextFloat()*numvars);
                if(!tuples.in(gsvars, vars[varIndex]))
                {
                    gsvars[counter]=vars[varIndex];
                    counter++;
                }
            }
            int [][] tab=tuples.generatetuples(arity, gsvars, r, numtuples);
            
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.reginlhomme)
            {
                new reginlhomme(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingale)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.nightingaleOneList)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone(), false, true);
            }
            else if(c==Ctype.simple)
            {
                new nightingaletuples(gsvars, prob, (int [][])tab.clone(), true, false);
            }
            else if(c==Ctype.trie)
            {
                new trieconstraint(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.simplebacktrack)
            {
                new gac_schema_positive(gsvars, prob, (int [][])tab.clone());
            }
        }
        System.gc();  // attempt to stop it gc'ing during the run.
        
        sw.zero();
        stopwatch swbackup=new stopwatch();
        swbackup.start();
        sw.start();
        prob.establish();
        //sw.end();
        
        //System.out.println("Establish time: "+sw.elapsedMillis());
        //prob.printdomains();
        //sw.start();
        
        ifsat=prob.search();
        
        //System.out.println("Sat:"+ifsat);
        sw.end();
        swbackup.end();
        snstime=0;
        snscount=0;
        for(constraint cons : prob.constraints)
        {
            if(((gac_schema)cons).sw!=null){ 
            snstime+=((gac_schema)cons).sw.elapsedMicros();
            snscount+=((gac_schema)cons).snscount;
            }
        }
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMicros();
        //return swbackup.elapsedMillis()*1000;
    }
}

///////////////////////////////////////////////////////////////
// Different experiment for the sq/wq gac paper.

class ijcai07quant
{
    public static void main(String [] args)
    {
        ijcai07quant ex;
        Ctype c;
        //for(density=0.2; density<=0.8; density=density+0.3)
        {density=0.2;
        System.out.println("Density:"+density);
        
        c=Ctype.qcspsolve;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("QCSP-Solve");
        ex.runbunch(c);
        
        c=Ctype.sqgac;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("SQGAC");
        ex.runbunch(c);
        
        c=Ctype.gspredicate;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("WQGAC-predicate");
        ex.runbunch(c);
        
        c=Ctype.gspositive;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("WQGAC-positive");
        ex.runbunch(c);
        
        c=Ctype.qbfcsbj;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("QBF csbj");
        ex.runbunch(c);
        
        c=Ctype.qbfquantor;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("QBF Quantor");
        ex.runbunch(c);
        
        c=Ctype.qbfskizzo;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("QBF Skizzo");
        ex.runbunch(c);
        
        c=Ctype.qbfquberel;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("QBF Qube Rel");
        ex.runbunch(c);
        
        
        
        /*c=Ctype.qbfqubebj;
        ex=new ijcai07quant();
        ex.r=new Random(12345);
        System.out.println("QBF Qube BJ");
        ex.runbunch(c);*/
        }
    }
    
    void runbunch(Ctype c)
    {
        //for(int arity=5; arity<=11; arity=arity+2)
        {int arity=10;
        System.out.println("arity:"+arity);
        //for(int d=2; d<=5; d++)
        {int d=2;  // for easy encoding to QBF.
        int numvars;
        /*if(d==2) numvars=25;
        else if(d==3) numvars=13;
        else if(d==4) numvars=8;
        else numvars=7; // d==5
        
        if(arity==7) numvars--;
        else if(arity==9) numvars=numvars-2;
        else if(arity==11) numvars=numvars-3;
        
        if(density==0.8) numvars=numvars-3;  // make it a bit easier*/
        
        numvars=25;
        
        //if(arity>numvars) break;
        
        //if(arity==7 && d>=5) break;
        //if(arity==9 && d>=4) break;
        //if(arity==11 && d>=3) break;
        
        for(int numcons=1; numcons<=15; numcons=numcons+1)
        {
            long time=0;
            long snstimelocal=0;
            long snscountlocal=0;
            int numsat=0;
            int tries=10;
            for(int i=0; i<tries; i++){
                time+=runtest(d, c, arity, numcons, numvars);
                snstimelocal+=snstime;
                snscountlocal+=snscount;
                numsat+=(ifsat?1:0);
            }
            System.out.println("d:"+d+" numcons:"+numcons+" numvars:"+numvars+" time for suite:"+time+" numsat:"+numsat+"/"+tries);
            //if(numsat<=(tries/4)) break;  // below the quartile, stop.
        }
        }
        }
    }
    
    Random r; // random number generator.
    stopwatch2 sw;
    
    static double density;
    
    // returns from the runtest method.
    long snstime;
    long snscount;
    //long domainchecks;
    boolean ifsat=false;
    
    long runtest(int d, Ctype c, int arity, int numcons, int numvars)
    {
        sw=new stopwatch2();
        // generate a model and run it for each propagator.
        qcsp prob=new qcsp(false, false, false, false, false);
        mid_domain [] vars=new mid_domain[numvars];
        
        for(int i=0; i<numvars; i++)
        {
            if(i==5 || i==5 || i==11 || i==11 || i==17 || i==17 || i==23 || i==23)
            {
                vars[i]=new universal(d, prob, "ux"+i);  // d for domain size.
            }
            else
            {
                vars[i]=new existential(d, prob, "ex"+i);  // d for domain size.
            }
        }
        
        numclauses=0;
        StringBuffer clauses=new StringBuffer();
        
        StringBuffer doms=new StringBuffer();
        StringBuffer hidvars=new StringBuffer();
        StringBuffer constemplates=new StringBuffer();
        StringBuffer conflicts=new StringBuffer();
        int hnumber=numvars;
        
        // gen  constraints.
        for(int i=0; i<numcons; i++)
        {
            // pick arity variables
            mid_domain [] gsvars=new mid_domain[arity];
            int counter=0;
            while(counter<arity)
            {
                int varIndex=(int) Math.floor(r.nextFloat()*numvars);
                if(!tuples.in(gsvars, vars[varIndex]))
                {
                    gsvars[counter]=vars[varIndex];
                    counter++;
                }
            }
            
            //sort
            varcompare vc=new varcompare();
            Arrays.sort(gsvars, vc);
            
            //int [][] tab=tuples.generateprobability(arity, gsvars, r, (float) density);
            
            int [][] tab=tuples.generatetuples(arity, gsvars, r, Math.round((float) (density* Math.pow((double)d, (double)arity ))));
            
            // construct constraint
            predicate_wrapper p1=new table_predicate((int [][])tab.clone());
            
            if(c==Ctype.sqgac || c==Ctype.qcspsolve)
            {
                new sqgac(gsvars, prob, p1);
            }
            else if(c==Ctype.gspredicate)
            {
                new gac_schema_predicate(gsvars, prob, p1); // warning: predicate maynot be efficient.
            }
            else if(c==Ctype.gspositive)
            {
                new gac_schema_positive(gsvars, prob, (int [][])tab.clone());
            }
            else if(c==Ctype.qbfquantor || c==Ctype.qbfquberel || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
            {
                genclauses(tab, clauses, gsvars);
            }
        }
        System.gc();  // attempt to stop it gc'ing during the run.
        
        if(c==Ctype.qbfquantor || c==Ctype.qbfquberel  || c==Ctype.qbfqubebj || c==Ctype.qbfskizzo || c==Ctype.qbfcsbj)
        {
            sw.zero();
            sw.start();
            runqbfsolvers(c, clauses, vars);
            sw.end();
            return sw.elapsedMicros();
        }
        else if(c==Ctype.qcspsolve)
        {
            //encoding.outputqcspinstance(doms, hidvars, constemplates, conflicts, vars, numcons);
            encoding.qcspencodeproblem(prob);
            sw.zero();
            sw.start();
            runbinarysolver(c);
            sw.end();
            return sw.elapsedMicros();
        }
        else
        {
        sw.zero();
        stopwatch swbackup=new stopwatch();
        swbackup.start();
        sw.start();
        ifsat=prob.establish();
        //sw.end();
        
        //System.out.println("Establish time: "+sw.elapsedMillis());
        //prob.printdomains();
        //sw.start();
        
        if(ifsat) ifsat=prob.search();
        
        //System.out.println("Sat:"+ifsat);
        sw.end();
        swbackup.end();
        snstime=0;
        snscount=0;
        for(constraint cons : prob.constraints)
        {
            if(!(cons instanceof gac_schema)) break;
            
            if(((gac_schema)cons).sw!=null){ 
            snstime+=((gac_schema)cons).sw.elapsedMicros();
            snscount+=((gac_schema)cons).snscount;
            }
        }
        
        //System.out.println("Search time: "+sw.elapsedMillis()+" nodes:"+prob.numnodes);
        return sw.elapsedMicros();
        }
        //return swbackup.elapsedMillis()*1000;
    }
    
    void runqbfsolvers(Ctype c, StringBuffer sb, mid_domain [] vars)
    {
        // first print out the instance.
        String st="p cnf "+vars.length+" "+numclauses+"\n";
        
        for(int i=0; i<vars.length; i++)
        {
            if(vars[i].quant()) 
            {
                st+="a "+(vars[i].id()+1)+" 0\n";
            }
            else
            {
                st+="e "+(vars[i].id()+1)+" 0\n";
            }
        }
        
        sb.insert(0, st);
        
        try
        {
            File output = new File("myinstance.qdimacs");
            FileWriter out = new FileWriter(output);
            out.write(sb.toString());
            out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing myinstance.qbf");
        }
        Process p=null;
        try
        {
            if(c==Ctype.qbfcsbj)
                p = Runtime.getRuntime().exec("/home/pn/bin/csbj myinstance.qdimacs");
            else if(c==Ctype.qbfquantor)
                p = Runtime.getRuntime().exec("/home/pn/bin/quantor myinstance.qdimacs");
            else if(c==Ctype.qbfquberel)
                p = Runtime.getRuntime().exec("/home/pn/bin/quberel myinstance.qdimacs");
            else if(c==Ctype.qbfqubebj)
                p = Runtime.getRuntime().exec("/home/pn/bin/qubebj myinstance.qdimacs");
            else if(c==Ctype.qbfskizzo)
                p = Runtime.getRuntime().exec("/home/pn/bin/skizzo myinstance.qdimacs");
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem running solver");
        }
        
        try
        {
            int retval=p.waitFor();
            assert retval==0;
        } catch(java.lang.Exception e)
        {
            System.out.println("Problem waiting");
        }
    }
    
    static int numclauses;
    
    void runbinarysolver(Ctype c)
    {   
        Process p=null;
        
        if(c==Ctype.qcspsolve)
        {
            try
            {
                p = Runtime.getRuntime().exec("/home/pn/bin/qcspsolve myinstance.qcsp");
            }
            catch(java.lang.Exception e)
            {
                System.out.println("Problem running solver");
            }
            try
            {
                int retval=p.waitFor();
                //assert retval==0;
            } catch(java.lang.Exception e)
            {
                System.out.println("Problem waiting");
            }
            return;
        }
        assert false;
    }
    
    void genclauses(int [][] table, StringBuffer sb, mid_domain [] consvars)
    {
        int [][] fliptable=tuples.fliptable(table, consvars);
        numclauses+=fliptable.length;
        for(int i=0; i<fliptable.length; i++)
        {
            for(int j=0; j<fliptable[i].length; j++)
            {
                sb.append((((variable)consvars[j]).id()+1) * ((fliptable[i][j]==0)?1:-1));
                sb.append(" ");
            }
            sb.append("0\n");
        }
    }
}

