package queso.experiments;

import gnu.trove.*;
import java.io.*;

import queso.core.*;
import queso.constraints.*;
import queso.encoding.*;

class noughts3 extends qcsp
{   
    noughts3()
    {
        super(true, false, false, false, false);
    }
    
    public void printsol()
    {
        for(int i=0; i<6; i++)
        {
            String st="board"+i+":";
            System.out.println("Board at move "+i);
            for(int j=0; j<9; j++)
            {
                System.out.print(findval(st+j)+" | ");
                if(j==2||j==5||j==8) System.out.println();
            }
        }
        
        System.out.println("Last two moves:"+findval("move6")+" "+findval("move7"));
        
        for(int i=0; i<variables.size(); i++)
        {
            mid_domain v=(mid_domain)variables.get(i);
            System.out.print(v.toString()+"="+v.domain());
            
            System.out.print(" ");
        }
        System.out.println();
        verifysol();
    }
    
    // this should be factored out.
    int findval(String varname) // given a variable name, return the value.
    {
        for(variable t : variables)
        {
            if(t.toString().equals(varname))
            {
                mid_domain t2=(mid_domain)t;
                for(int j=t2.lowerbound(); j<=t2.upperbound(); j++)
                {
                    if(t2.is_present(j))
                    {
                        return j;
                    }
                }
                assert false: "No value found for variable "+varname;
            }
        }
        assert false: "No variable found:"+varname;
        return -1;
    }
    
    void verifysol()
    {
        int [] board=new int[9];
        
        for(int move=0; move<9; move++)
        {
            int themove=findval("move"+move);
            assert board[move]==0;
            if(move%2==0) board[move]=10; else board[move]=11;
            int temp=wins(board);
            if(temp==0)
            {
                assert false: "Claimed true is not a true.";
            }
            else if(temp==1)
            {
                return;
            }
            
        }
        
        assert false: "Claimed true is not a true.";
    }
    
    int wins(int []board)
    {
        // player 10 lost == 0, wins ==1 and undetermined==2
        if( (board[0]==10 && board[1]==10 && board[2]==10)
        || (board[3]==10 && board[4]==10 && board[5]==10)
        || (board[6]==10 && board[7]==10 && board[8]==10)
        
        // verticals
        || (board[0]==10 && board[3]==10 && board[6]==10)
        || (board[1]==10 && board[4]==10 && board[7]==10)
        || (board[2]==10 && board[5]==10 && board[8]==10)
        
        // diagonals
        || (board[0]==10 && board[4]==10 && board[8]==10)
        || (board[2]==10 && board[4]==10 && board[6]==10) )
        {
            return 1;
        }
        
        if( (board[0]==11 && board[1]==11 && board[2]==11)
        || (board[3]==11 && board[4]==11 && board[5]==11)
        || (board[6]==11 && board[7]==11 && board[8]==11)
        
        // verticals
        || (board[0]==11 && board[3]==11 && board[6]==11)
        || (board[1]==11 && board[4]==11 && board[7]==11)
        || (board[2]==11 && board[5]==11 && board[8]==11)
        
        // diagonals
        || (board[0]==11 && board[4]==11 && board[8]==11)
        || (board[2]==11 && board[4]==11 && board[6]==11) )
        {
            return 0;
        }
        // it's indeterminate
        
        return 2;
    }
}

public class noughtspure3
{
    public static void main(String[] args)
    {
        runit(Ctype.nightingale, false, Ctype.sqgac);
        runit(Ctype.nightingale, false, Ctype.sqgac);
        runit(Ctype.nightingaleOneList, false, Ctype.sqgac);
        runit(Ctype.nightingaleOneList, false, Ctype.sqgac);
        runit(Ctype.sqgac, false, Ctype.sqgac);
        runit(Ctype.sqgac, false, Ctype.sqgac);
        runit(Ctype.gspositive, false, Ctype.sqgac);
        runit(Ctype.gspositive, false, Ctype.sqgac);
        runit(Ctype.gspredicate, false, Ctype.sqgac);
        runit(Ctype.gspredicate, false, Ctype.sqgac);
        
        runit(Ctype.sqgac, true, Ctype.gspositive);
        runit(Ctype.sqgac, true, Ctype.gspredicate);
        runit(Ctype.sqgac, true, Ctype.nightingale);
        runit(Ctype.sqgac, true, Ctype.nightingaleOneList);
        runit(Ctype.sqgac, true, Ctype.sqgac);
    }
    
    static void runit(Ctype cons_type, boolean big_end_cons, Ctype big_end_type)
    {
        System.out.println("Running for cons_type:"+cons_type+" big_end_cons:"+big_end_cons+" big_end_type:"+big_end_type);
        System.gc();
        qcsp prob = new noughts3();
        
        mid_domain[] moves=new mid_domain[9];
        
        mid_domain[] shadowmoves=new mid_domain[9];
        
        mid_domain[][] board=new mid_domain[9][];
        
        //mid_domain[][] available=new mid_domain[9][];
        
        mid_domain[] winstate=new mid_domain[9];
        
        mid_domain[] xline=new mid_domain[9];
        mid_domain[] oline=new mid_domain[9];
        
        /*boolean big_end_cons=false; // do we have all 9 moves, or 6 moves and a big end constraint?
        Ctype big_end_type=Ctype.gspredicate;  // 0 for sqgac, 1 for gspositive, 2 for gspredicate
        
        Ctype cons_type=Ctype.sqgac;*/
        
        for(int move=0; move< ((big_end_cons)?6:9 ) ; move++)
        {
            // board state mid_domains
            board[move]=new mid_domain[9];
            //available[move]=new mid_domain[9];
        }
        
        for(int move=0; move< ((big_end_cons)?6:9) ; move++) // what move are we on.
        {
            // make move variables
            if((move%2)==0)  // odd numbers
            {
                moves[move]=new existential(9, prob, "move"+move);
            }
            else
            {
                moves[move]=new universal(9, prob, "move"+move);
                shadowmoves[move]=new existential(9, prob, "shadowmove"+move);
            }
            
            for(int i=0; i<9; i++)
            {
                board[move][i]=new existential(3, prob, "board"+move+":"+i);  // x, o or unoccupied= 0, 1 or 2
                if(move==0 || move==2 || move==4 || move==6)
                {
                    //available[move+1][i]=new existential(2, prob, "available["+(move+1)+"]["+i+"]");  // 1 is empty, 0 is occupied
                }
            }
            
            // winstate per move
            
            winstate[move]=new existential(3, prob, "winstate"+move);
            
            xline[move]=new existential(2, prob, "xline"+move);
            
            oline[move]=new existential(2, prob, "oline"+move);

            // connect move variables to board variables.
            if((move%2)==0)
            {
                if(move==0)
                {
                    for(int i=0; i<9; i++)
                    {
                        {firstxmove_predicate p1=new firstxmove_predicate(i);
                        mid_domain[] gsvars = new mid_domain[2];
                        gsvars[0]=board[0][i];
                        gsvars[1]=moves[0];
                        connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
                        }
                    }
                }
                else
                {
                    for(int i=0; i<9; i++)
                    {
                        {xmove_predicate p1=new xmove_predicate(i);
                        mid_domain[] gsvars = new mid_domain[3];
                        gsvars[0]=board[move-1][i];
                        gsvars[1]=moves[move];
                        gsvars[2]=board[move][i];
                        
                        connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
                        }
                    }
                }
            }
            else
            {
                // o move now using combined constraint for the move variable 
                
                // o move using pure propagator and xmove predicate
                
                for(int i=0; i<9; i++)
                {
                    {omove_predicate p1=new omove_predicate(i);
                    mid_domain[] gsvars = new mid_domain[3];
                    gsvars[0]=board[move-1][i];
                    gsvars[1]=shadowmoves[move];
                    gsvars[2]=board[move][i];
                    
                    connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
                    }
                }
            }
            
            // detect lines and map onto appropriate xline or oline var.
            
            if(move==4 || move==6 || move==8)
            {
                // x can win by move 4, so start checking for lines here.
                System.out.println("Setting up xline_constraint for move"+move);
                xline_predicate p1=new xline_predicate();
                mid_domain[] gsvars= new mid_domain[10];
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                System.out.println("Setting up xline_constraint for var"+xline[move]);
                gsvars[9]=xline[move];
                
                connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
                
                //  not owins[move-1] and xline[move] <=> xwins[move] and not owins[move]
                // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1]
            }
            
            if(move==5 || move==7)
            {
                // o can win by move 5, so start checking for lines here.
                
                oline_predicate p1=new oline_predicate();
                mid_domain[] gsvars= new mid_domain[10];
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                
                gsvars[9]=oline[move];
                
                connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
            }
            
            // This is a standardised pure construction based on the design pattern.
            if((move%2)==1)
            {
                for(int i=0; i<9; i++)
                {
                    // The regular constraint part
                    predicate_wrapper p1=new hacked_designpattern(i);
                    {
                    mid_domain[] gsvars = new mid_domain[3];
                    gsvars[0]=board[move-1][i]; System.out.println(board[move-1][i].toString());
                    gsvars[1]=moves[move]; System.out.println(moves[move].toString());
                    gsvars[2]=shadowmoves[move]; System.out.println(shadowmoves[move].toString());
                    connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
                    }
                }
            }
            
            if(move>=1)  // from move 1 something can happen i.e. o can cheat.
            {
                mid_domain[] gsvars= new mid_domain[4];
                gsvars[0]=winstate[move-1];
                gsvars[1]=xline[move];
                gsvars[2]=oline[move];
                gsvars[3]=winstate[move];
                
                logic_predicate p1=new logic_predicate();
                
                connectfourfull.mkconstraint(prob, cons_type, gsvars, p1);
            }
        }
        
        if(big_end_cons)
        {
            moves[6]=new existential(3, prob, "move6");
            
            moves[7]=new universal(2, prob, "move7");
            
            // make the big end constraint
            // last three moves -- last move is unit.
            {mid_domain [] tempvar=new mid_domain[12];
            System.arraycopy(board[5], 0, tempvar, 0, 9);
            tempvar[9]=winstate[5];
            
            tempvar[10]=moves[6];
            tempvar[11]=moves[7];
            
            for(int i=0; i<tempvar.length; i++)
                System.out.println(tempvar[i]+" ");
            
            System.out.println();
            
            lastmoves_predicate p1=new lastmoves_predicate();
            
            connectfourfull.mkconstraint(prob, big_end_type, tempvar, p1);
            }
        }
        
        if(cons_type==Ctype.sqgac && (!big_end_cons || big_end_type==Ctype.sqgac))
        {
            encoding.qcspencodeproblem(prob);  // might as well.
        }
        
        prob.pure_setup();  
        // enables the pure value rule, could take some time to execute since it constructs the whole problem again!
        
        // root node processing here.
        //System.out.println("Establish GAC list:");
        //System.out.println(prob.queue.toestablish);
        
        stopwatch sw= new stopwatch("GMT");
        sw.start();
        prob.establish();
        
        // set some variables
        
        winstate[0].exclude(0, null);
        //winstate[0].exclude(1, null);
        
        //xline[0].exclude(1, null); // these two found by pure value.
        //oline[0].exclude(1, null);
        
        xline[1].exclude(1, null);
        oline[1].exclude(1, null);
        
        xline[2].exclude(1, null);
        oline[2].exclude(1, null);
        
        xline[3].exclude(1, null);
        oline[3].exclude(1, null);
        
        // move 4 -- x line can happen now
        oline[4].exclude(1, null);
        
        xline[5].exclude(1, null);
        
        if(!big_end_cons)
        {
            oline[6].exclude(1, null);
            xline[7].exclude(1, null);
            oline[8].exclude(1, null);
            
            winstate[8].exclude(1, null);
            winstate[8].exclude(2, null);
        }
        if(cons_type==Ctype.sqgac && (!big_end_cons || big_end_type==Ctype.sqgac))
        {
            //encoding.qcspencodeproblem(prob);
        }
        
        // symmetry breaking
        /*board[0][2].instantiate(2);
        board[0][3].instantiate(2);
        board[0][5].instantiate(2);
        board[0][6].instantiate(2);
        board[0][7].instantiate(2);
        board[0][8].instantiate(2);*/
        
        prob.add_backtrack_level();
        
        prob.propagate();
        
        sw.end();
        System.out.println("Setup time: "+sw.elapsedMillis());
        
        //prob.printdomains();
        
        //System.out.println(prob.blocks);
        
        //System.out.println(
        sw= new stopwatch("GMT");
        
        sw.start();
        System.out.println(prob.search());
        
        //moves[0].instantiate(0);
        
        //prob.propagate();
        
        //prob.printdomains();
        
        sw.end();
        System.out.println("Search time: "+sw.elapsedMillis()+" , Nodes:"+prob.numnodes);
        
        try
        {
        File output = new File("noughtspure2.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(prob.printtree());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing noughtspure2.dot");
        }
        //System.out.println(cons);
    }
}
