//import java.util.*;
import gnu.trove.*;

// represent the bakers puzzle with just one 
// constraint and see how long it takes to establish GAC

// variables are interchangeable, so should exercise the multidirectionality
// Won't work because each value of f will have a different support... it's complete rubbish.

class bakers
{
    public static void main(String[] args)
    {
        int weightsnum=3;  // how many weights.
        
        int states=0;   // calculate the number of states
        
        for(int i=0; i<weightsnum; i++)
        {
            states+=(3**i);
        }
        
        System.out.println("States:"+states);
        
        qcsp prob = new qcsp();
        
        variable[] weights=new variable[weightsnum];    // last one is unit
        
        for(int i=0; i<weightsnum; i++)
        {
            weights[i]=new existential(states, prob, "weights:"+i);
            prob.addvar(weights[i]);
        }
        
        variable f=new universal(states, prob, "f");
        prob.addvar(f);
        
        
        
        prob.backtrack.add_backtrack_level();
        
        prob.propagate();
        
        prob.printdomains();
        
        System.out.println(prob.blocks);
        
        //System.out.println(
        
        System.out.println(prob.search(0));
    }
    
    // should really be templated
    static Object [] cat(Object oo1, Object oo2)
    {
        // Stick two things together
        if(oo1 instanceof Object [])
        {
            Object [] o1=(Object[]) oo1;
            if(oo2 instanceof Object [])
            {
                Object [] o2=(Object[])oo2;
                Object [] o3=new Object[o1.length+o2.length];
                System.arraycopy(o1, 0, o3, 0, o1.length);
	            System.arraycopy(o2, 0, o3, o1.length, o2.length);
                return o3;
            }
            else
            {
                Object o2=oo2;
                // stick o2 on the end of o1
                Object [] o3=new Object[o1.length+1];
                System.arraycopy(o1, 0, o3, 0, o1.length);
                o3[o3.length-1]=o2;
                return o3;
            }
        }
        else
        {
            Object o1=oo1;
            if(oo2 instanceof Object[])
            {
                // Stick o1 on the start of o2
                Object [] o2=(Object [])oo2;
                
                Object [] o3=new Object[o2.length+1];
                System.arraycopy(o2, 0, o3, 1, o2.length);
                o3[0]=o2;
                return o3;
            }
            else
            {
                Object []o3=new Object[2];
                o3[0]=o1;
                o3[1]=oo2;
                return o3;
            }
        }
    }
    
}

class bakers_predicate extends predicate_wrapper
{
    // connect a boardstate variable in 0,1,2
    // to the next.
    
    public boolean predicate(tuple tau)
    {
        if(tau.vals[0]!=2)
        {
            return tau.vals[0]==tau.vals[1];
        }
        
        return true;
    }
}

class findline_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // tau[0] is the old winstate.
        // tau[1..9] is the 
        // tau[10] is the new winstate  // 0/1/2 variable indicating player x o and no-one won.
        
        if(tau.vals[0]!=2)
        {
            return tau.vals[10]==tau.vals[0];
        }
        
        // does x have a line?
        
        if( (tau.vals[1]==0 && tau.vals[2]==0 && tau.vals[3]==0)
        || (tau.vals[4]==0 && tau.vals[5]==0 && tau.vals[6]==0)
        || (tau.vals[7]==0 && tau.vals[8]==0 && tau.vals[9]==0)
        
        // verticals
        || (tau.vals[1]==0 && tau.vals[4]==0 && tau.vals[7]==0)
        || (tau.vals[2]==0 && tau.vals[5]==0 && tau.vals[8]==0)
        || (tau.vals[3]==0 && tau.vals[6]==0 && tau.vals[9]==0)
        
        // diagonals
        || (tau.vals[1]==0 && tau.vals[5]==0 && tau.vals[9]==0)
        || (tau.vals[3]==0 && tau.vals[5]==0 && tau.vals[7]==0) )
        {
            // so x has a line
            return tau.vals[10]==0;
        }
        
        // does o have a line
        if( (tau.vals[1]==1 && tau.vals[2]==1 && tau.vals[3]==1)
        || (tau.vals[4]==1 && tau.vals[5]==1 && tau.vals[6]==1)
        || (tau.vals[7]==1 && tau.vals[8]==1 && tau.vals[9]==1)
        
        // verticals
        || (tau.vals[1]==1 && tau.vals[4]==1 && tau.vals[7]==1)
        || (tau.vals[2]==1 && tau.vals[5]==1 && tau.vals[8]==1)
        || (tau.vals[3]==1 && tau.vals[6]==1 && tau.vals[9]==1)
        
        // diagonals
        || (tau.vals[1]==1 && tau.vals[5]==1 && tau.vals[9]==1)
        || (tau.vals[3]==1 && tau.vals[5]==1 && tau.vals[7]==1) )
        {
            // so 0 has a line
            return tau.vals[10]==1;
        }
        
        // neither party has a line.
        return tau.vals[10]==2;
    }
}

class middle_predicate extends predicate_wrapper
{
    // this constraint is deliberately loose because it is so huge. Requires additional boardstate constraints.
    // and winstate constraints.
    
    public boolean predicate(tuple tau)
    {
        // tau[0..8] is boardstate before
        // tau[9] is winstate before
        // tau[10] is move1 (Existential)
        // tau[11] is move2 (universal)
        // tau[12..20] is boardstate after
        
        int [] vals=tau.vals;
        
        if(tau.vals[9]!=2)    // if someone has already won, this cons is satisfied.
            return true;
        
        int move1=vals[10];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move1++;
            }
            
            if(move1<=i)
            {
                break;
            }
        }
        
        int move2=vals[11];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move2++;
            }
            
            if(move2==move1)
            {
                move2++;
            }
            
            if(move2<=i)
            {
                break;
            }
        }
        
        // set the following boardstate variables
        //System.out.println("move1:"+move1+" move2:"+move2);
        
        if(move1>8 || move2>8)
        {
            //this tuple is weird
            return false;
        }
        
        if(vals[12+move1]!=0)
            return false;
           
        if(vals[12+move2]!=1)
            return false;
        
        return true;
    }
}

class first_predicate extends predicate_wrapper
{
    // this constraint is deliberately loose because it is so huge. Requires additional boardstate constraints.
    // and winstate constraints.
    
    public boolean predicate(tuple tau)
    {
        // tau[0] is move1 (Existential)
        // tau[1] is move2 (universal)
        // tau[2..10] is boardstate after
        
        int [] vals=tau.vals;
        
        int move1=vals[0];
        
        int move2=vals[1];
        
        if(move2>=move1)
            move2++;
        
        // set the following boardstate variables
        
        for(int i=2; i<11; i++)
        {
            if(i==(2+move1))
            {
                if(vals[i]!=0)
                    return false;
            }
            else if(i==(2+move2))
            {
                if(vals[i]!=1)
                    return false;
            }
            else
            {
                if(vals[i]!=2)
                    return false;
            }
        }
        
        return true;
    }
}

class last_predicate extends predicate_wrapper
{
    // this constraint is deliberately loose because it is so huge. Requires additional boardstate constraints.
    // and winstate constraints.
    
    public boolean predicate(tuple tau)
    {   
        // tau[0..8] is boardstate before
        // tau[9] is winstate before
        // tau[10] is move1 (existential)
        // tau[11] is move2 (universal)
        
        int [] vals=tau.vals;
        
        if(vals[9]!=2)    // if someone has already won, this cons is satisfied iff it is the first player.
            return vals[9]==0;
        
        int move1=vals[10];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move1++;
            }
            
            if(move1<=i)
            {
                break;
            }
        }
        
        int move2=vals[11];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move2++;
            }
            
            if(move2==move1)
            {
                move2++;
            }
            
            if(move2<=i)
            {
                break;
            }
        }
        
        // copy to be sure we don't alter the tuple
        int [] board=new int[9];
        for(int i=0; i<9; i++)
            board[i]=vals[i];
        
        assert board[move1]==2;
        
        board[move1]=0;
        
        // if x has won after move1, then return true.
        
        if( (board[0]==0 && board[1]==0 && board[2]==0)
        || (board[3]==0 && board[4]==0 && board[5]==0)
        || (board[6]==0 && board[7]==0 && board[8]==0)
        
        // verticals
        || (board[0]==0 && board[3]==0 && board[6]==0)
        || (board[1]==0 && board[4]==0 && board[7]==0)
        || (board[2]==0 && board[5]==0 && board[8]==0)
        
        // diagonals
        || (board[0]==0 && board[4]==0 && board[8]==0)
        || (board[2]==0 && board[4]==0 && board[6]==0) )
        {
            return true;
        }
        
        // if o has won after move2, then return false;
        
        if( (board[0]==1 && board[1]==1 && board[2]==1)
        || (board[3]==1 && board[4]==1 && board[5]==1)
        || (board[6]==1 && board[7]==1 && board[8]==1)
        
        // verticals
        || (board[0]==1 && board[3]==1 && board[6]==1)
        || (board[1]==1 && board[4]==1 && board[7]==1)
        || (board[2]==1 && board[5]==1 && board[8]==1)
        
        // diagonals
        || (board[0]==1 && board[4]==1 && board[8]==1)
        || (board[2]==1 && board[4]==1 && board[6]==1) )
        {
            return false;
        }
        
        // find and fill in the one remaining empty slot, then test again if 
        // x has won.
        
        for(int i=0; i<9; i++)
        {
            if(board[i]==2){ board[i]=0; break; }
        }
        
        if( (board[0]==0 && board[1]==0 && board[2]==0)
        || (board[3]==0 && board[4]==0 && board[5]==0)
        || (board[6]==0 && board[7]==0 && board[8]==0)
        
        // verticals
        || (board[0]==0 && board[3]==0 && board[6]==0)
        || (board[1]==0 && board[4]==0 && board[7]==0)
        || (board[2]==0 && board[5]==0 && board[8]==0)
        
        // diagonals
        || (board[0]==0 && board[4]==0 && board[8]==0)
        || (board[2]==0 && board[4]==0 && board[6]==0) )
        {
            return true;
        }
        
        // it's a draw.
        
        return false;
    }
}
