//import java.util.*;
import gnu.trove.*;

class cons_used_here extends gac_schema_predicate4
{
    cons_used_here(variable [] v, qcsp p, predicate_wrapper p1)
    {
        super(v,p,p1);
    }
}

class crosses extends qcsp
{
    void printsol()
    {
        for(int i=0; i<9; i++)
        {
            String st="board"+i+":";
            System.out.println("Board at move "+i);
            for(int j=0; j<9; j++)
            {
                System.out.print(findval(st+j)+" | ");
                if(j==2||j==5||j==8) System.out.println();
            }
        }

        for(int i=0; i<variables.size(); i++)
        {
            System.out.print(variables.get(i).name+"=");
            //System.out.print(variables.get(i).quant);

            //System.out.print(", ");
            for(int j=0; j<variables.get(i).hash.length; j++)
            {
                if(variables.get(i).hash[j]==0)
                {
                    System.out.print(j);
                }
            }
            System.out.print(" ");
        }
        System.out.println();
    }

    int findval(String varname) // given a variable name, return the value.
    {
        for(variable t : variables)
        {
            if(t.name.equals(varname))
            {   
                for(int j=0; j<t.hash.length; j++)
                {
                    if(t.hash[j]==0)
                    {
                        return j;
                    }
                }
            }
        }
        assert false;
        return -1;
    }
}

class noughts
{
    public static void main(String[] args)
    {
        qcsp prob = new crosses();
        
        variable[] moves=new variable[9];
        
        variable[][] board=new variable[9][];
        
        variable[] xwins=new variable[9];
        variable[] owins=new variable[9];
        
        variable[] xline=new variable[9];
        variable[] oline=new variable[9];
        
        for(int move=0; move<9; move++) // what move are we on.
        {
            // make move variables
            if((move%2)==0)
            {
                moves[move]=new existential(9, prob, "move"+move);
                prob.addvar(moves[move]);
            }
            else
            {
                moves[move]=new universal(9, prob, "move"+move);
                prob.addvar(moves[move]);
            }
            
            // board state variables
            board[move]=new variable[9];
            
            for(int i=0; i<9; i++)
            {
                board[move][i]=new existential(3, prob, "board"+move+":"+i);  // x, o or unoccupied= 0, 1 or 2
                prob.addvar(board[move][i]);
            }
            
            // connect move variables to board variables.
            if((move%2)==0)
            {
                if(move==0)
                {
                    for(int i=0; i<9; i++)
                    {
                        firstxmove_predicate p1=new firstxmove_predicate(i);
                        variable[] gsvars = new variable[2];
                        gsvars[0]=board[0][i];
                        gsvars[1]=moves[0];
                        cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                        cons.establish_gac();
                    }
                }
                else
                {
                    for(int i=0; i<9; i++)
                    {
                        xmove_predicate p1=new xmove_predicate(i);
                        variable[] gsvars = new variable[3];
                        gsvars[0]=board[move-1][i];
                        gsvars[1]=moves[move];
                        gsvars[2]=board[move][i];
                        cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                        cons.establish_gac();
                    }
                }
            }
            else
            {
                for(int i=0; i<9; i++)
                {
                    omove_predicate p1=new omove_predicate(i);
                    variable[] gsvars = new variable[3];
                    gsvars[0]=board[move-1][i];
                    gsvars[1]=moves[move];
                    gsvars[2]=board[move][i];
                    cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                    cons.establish_gac();
                }
            }
            
            // xwins per move
            
            // x can win at move 4 but xwins[4]=xline[4] so no need to create a new variable here.
            if(move>=5)
            {
                xwins[move]=new existential(2, prob, "xwins"+move);
                prob.addvar(xwins[move]);
                
                owins[move]=new existential(2, prob, "owins"+move);
                prob.addvar(owins[move]);
            }
            
            if(move==4)
            {
                owins[move]=new existential(2, prob, "owins"+move);  // set to false immediately
                prob.addvar(owins[move]);
            }
            
            // detect lines and map onto appropriate xline or oline var.
            
            if(move==4 || move==6 || move==8)
            {
                // x can win by move 4, so start checking for lines here.
                
                xline_predicate p1=new xline_predicate();
                variable[] gsvars= new variable[10];
                
                xline[move]=new existential(2, prob, "xline"+move);
                prob.addvar(xline[move]);
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                
                gsvars[9]=xline[move];
                
                cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                cons.establish_gac();
                
                if(move==4)
                {
                    xwins[4]=xline[4];
                }
                else
                {
                    //  not owins[move-1] and xline[move] <=> xwins[move] and not owins[move]
                    // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1] 
                    variable[] tempvars= new variable[5];
                    tempvars[0]=xwins[move-1];
                    tempvars[1]=owins[move-1];
                    tempvars[2]=xwins[move];
                    tempvars[3]=owins[move];
                    tempvars[4]=xline[move];
                    
                    logic_predicate p2=new logic_predicate();
                    cons_used_here cons2= new cons_used_here(tempvars, prob, p2);
                    cons2.establish_gac();
                }
                
            }
            
            if(move==5 || move==7)
            {
                // o can win by move 5, so start checking for lines here.
                
                oline_predicate p1=new oline_predicate();
                variable[] gsvars= new variable[10];
                
                oline[move]=new existential(2, prob, "oline"+move);
                prob.addvar(oline[move]);
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                
                gsvars[9]=oline[move];
                
                gac_schema_predicate2 cons= new gac_schema_predicate2(gsvars, prob, p1);
                cons.establish_gac();
                
                //  not owins[move-1] and oline[move] <=> xwins[move] and not owins[move]
                // connect  oline[move]. owins[move] and owins[move] to xwins[move-1] and owins[move-1] 
                variable[] tempvars= new variable[5];
                tempvars[0]=owins[move-1];
                tempvars[1]=xwins[move-1];
                tempvars[2]=owins[move];
                tempvars[3]=xwins[move];
                tempvars[4]=oline[move];
                
                logic_predicate p2=new logic_predicate();
                cons_used_here cons2= new cons_used_here(tempvars, prob, p2);
                cons2.establish_gac();
            }
            
            // moves where o cheats should be pure, so don't forget the pure literal rule!!
        }
        // set xwins[8] to true
        xwins[8].exclude(0, null);
        owins[4].exclude(1, null);
        
        prob.backtrack.add_backtrack_level();
        
        prob.propagate();
        
        prob.printdomains();
        
        System.out.println(prob.blocks);
        
        //System.out.println(
        
        System.out.println(prob.search(0));
    }
}

class xline_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // first 9 entries in tau are the board, and the tenth is a 0/1 variable indicating if player 0 has won.
        
        if( (tau.vals[0]==0 && tau.vals[1]==0 && tau.vals[2]==0)
        || (tau.vals[3]==0 && tau.vals[4]==0 && tau.vals[5]==0)
        || (tau.vals[6]==0 && tau.vals[7]==0 && tau.vals[8]==0)
        
        // verticals
        || (tau.vals[0]==0 && tau.vals[3]==0 && tau.vals[6]==0)
        || (tau.vals[1]==0 && tau.vals[4]==0 && tau.vals[7]==0)
        || (tau.vals[2]==0 && tau.vals[5]==0 && tau.vals[8]==0)
        
        // diagonals
        || (tau.vals[0]==0 && tau.vals[4]==0 && tau.vals[8]==0)
        || (tau.vals[2]==0 && tau.vals[4]==0 && tau.vals[6]==0) )
        {
            // so x has a line
            if(tau.vals[9]==1)
            {
                return true;
            }
            else
            {
                assert tau.vals[9]==0;
                return false;
            }
        }
        else
        {
            // x does not have a line
            if(tau.vals[9]==1)
            {
                return false;
            }
            else
            {
                assert tau.vals[9]==0;
                return true;
            }
        }
    }
}

class oline_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // first 9 entries in tau are the board, and the tenth is a 0/1 variable indicating if player 0 has won.

        if( (tau.vals[0]==1 && tau.vals[1]==1 && tau.vals[2]==1)
        || (tau.vals[3]==1 && tau.vals[4]==1 && tau.vals[5]==1)
        || (tau.vals[6]==1 && tau.vals[7]==1 && tau.vals[8]==1)

        // verticals
        || (tau.vals[0]==1 && tau.vals[3]==1 && tau.vals[6]==1)
        || (tau.vals[1]==1 && tau.vals[4]==1 && tau.vals[7]==1)
        || (tau.vals[2]==1 && tau.vals[5]==1 && tau.vals[8]==1)

        // diagonals
        || (tau.vals[0]==1 && tau.vals[4]==1 && tau.vals[8]==1)
        || (tau.vals[2]==1 && tau.vals[4]==1 && tau.vals[6]==1) )
        {
            // so o has a line
            if(tau.vals[9]==1)
            {
                return true;
            }
            else
            {
                assert tau.vals[9]==0;
                return false;
            }
        }
        else
        {
            // o does not have a line
            if(tau.vals[9]==1)
            {
                return false;
            }
            else
            {
                assert tau.vals[9]==0;
                return true;
            }
        }
    }
}

class logic_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1]
        //tempvars[0]=xwins[move-1];
        //tempvars[1]=owins[move-1];
        //tempvars[2]=xwins[move];
        //tempvars[3]=owins[move];
        //tempvars[4]=xline[move];
        
        if(tau.vals[0]==1)  // if x won last move, ensure that x wins this move and not o
        {
            if(tau.vals[2]==0)
                return false;
            
            if(tau.vals[3]==1)
                return false;
            
            if(tau.vals[1]==1)
                return false;
            
            return true;
        }
        
        if(tau.vals[1]==1)  // if o won last move, ensure that o wins this move and not x
        {
            if(tau.vals[3]==0)
                return false;
            
            if(tau.vals[2]==1)
                return false;
            
            if(tau.vals[0]==1)
                return false;
            
            return true;
        }
        
        // neither player won last move.
        
        if(tau.vals[4]==1)
        {
            // x wins this move
            if(tau.vals[2]==0)
                return false;
            
            if(tau.vals[3]==1)
                return false;
                
            return true;
        }
        else
        {
            // no-one wins this move
            if(tau.vals[2]==1)
                return false;
            
            if(tau.vals[3]==1)
                return false;
            
            return true;
        }
    }
}

class xmove_predicate extends predicate_wrapper
{
    final int pos;
    
    xmove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[0]) to oldboard position [1] and newboard position [2]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            // this is the existential player so we want to prune the cheating moves.
            return (tau.vals[0]==2 && tau.vals[2]==0);
        }
        else
        {
            return tau.vals[0]==tau.vals[2];
        }
    }
}

class omove_predicate extends predicate_wrapper
{
    final int pos;
    
    omove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[1]) to oldboard position [0] and newboard position [2]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            // this is the universal player so we want the cheating moves to be pure values.
            // But also to have no effect on the board state.?? really??
            if(tau.vals[0]!=2)
            {
                return tau.vals[0]==tau.vals[2];
            }
            
            if(tau.vals[2]!=1)
                return false;
            
            return true;
        }
        else
        {
            return tau.vals[0]==tau.vals[2];
        }
    }
}

class firstxmove_predicate extends predicate_wrapper
{
    final int pos;
    
    firstxmove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[1]) to newboard position [0]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            return (tau.vals[0]==0);
        }
        else
        {
            return tau.vals[0]==2;
        }
    }
}
