//import java.util.*;
import gnu.trove.*;

class cons_used_here extends gac_schema_predicate
{
    cons_used_here(fd_var [] v, qcsp p, predicate_wrapper p1)
    {
        super(v,p,p1);
    }
}

class crosses3 extends qcsp
{
    void printsol()
    {
        for(int i=0; i<6; i++)
        {
            String st="board"+i+":";
            System.out.println("Board at move "+i);
            for(int j=0; j<9; j++)
            {
                System.out.print(findval(st+j)+" | ");
                if(j==2||j==5||j==8) System.out.println();
            }
        }

        for(int i=0; i<variables.size(); i++)
        {
            fd_var v=(fd_var) variables.get(i);
            System.out.print(v+"=");
            //System.out.print(variables.get(i).quant);

            //System.out.print(", ");
            
            for(int j=0; j<v.domsize(); j++)
            {
                if(v.hash[j]==0)
                {
                    System.out.print(j);
                }
            }
            System.out.print(" ");
        }
        System.out.println();
    }
    
    int findval(String varname) // given a variable name, return the value.
    {
        for(variable t : variables)
        {
            if(t.name.equals(varname))
            {   
                for(int j=0; j<((fd_var)t).hash.length; j++)
                {
                    if(((fd_var)t).hash[j]==0)
                    {
                        return j;
                    }
                }
            }
        }
        assert false;
        return -1;
    }
}

class noughts3
{
    public static void main(String[] args)
    {
        runit();
        //runit();
        //runit();
    }
    
    static void runit()
    {
        qcsp prob = new crosses3();
        
        fd_var[] moves=new fd_var[8];
        
        fd_var[][] board=new fd_var[6][];
        
        fd_var[] winstate=new fd_var[6];
        
        fd_var[] xline=new fd_var[6];
        fd_var[] oline=new fd_var[6];
        
        for(int move=0; move<6; move++) // what move are we on.
        {
            // make move variables
            if((move%2)==0)
            {
                moves[move]=new existential(9, prob, "move"+move);
                prob.addvar(moves[move]);
            }
            else
            {
                moves[move]=new universal(9, prob, "move"+move);
                prob.addvar(moves[move]);
            }
            
            // board state variables
            board[move]=new fd_var[9];
            
            for(int i=0; i<9; i++)
            {
                board[move][i]=new existential(3, prob, "board"+move+":"+i);  // x, o or unoccupied= 0, 1 or 2
                prob.addvar(board[move][i]);
            }
            
            // winstate per move
            
            winstate[move]=new existential(3, prob, "winstate"+move);
            prob.addvar(winstate[move]);

            xline[move]=new existential(2, prob, "xline"+move);
            prob.addvar(xline[move]);

            oline[move]=new existential(2, prob, "oline"+move);
            prob.addvar(oline[move]);

            // connect move variables to board variables.
            if((move%2)==0)
            {
                if(move==0)
                {
                    for(int i=0; i<9; i++)
                    {
                        firstxmove_predicate p1=new firstxmove_predicate(i);
                        fd_var[] gsvars = new fd_var[2];
                        gsvars[0]=board[0][i];
                        gsvars[1]=moves[0];
                        cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                    }
                }
                else
                {
                    for(int i=0; i<9; i++)
                    {
                        xmove_predicate p1=new xmove_predicate(i);
                        fd_var[] gsvars = new fd_var[3];
                        gsvars[0]=board[move-1][i];
                        gsvars[1]=moves[move];
                        gsvars[2]=board[move][i];
                        cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                    }
                }
            }
            else
            {
                // o move using special propagator and xmove predicate
                for(int i=0; i<9; i++)
                {
                    {omove_special_predicate p1=new omove_special_predicate(i);
                    fd_var[] gsvars = new fd_var[3];
                    gsvars[0]=board[move-1][i];
                    gsvars[1]=moves[move];
                    gsvars[2]=board[move][i];
                    gac_schema_predicate_special cons= new gac_schema_predicate_special(gsvars, prob, p1);}
                    
                    {omove_normal_predicate p1=new omove_normal_predicate(i);
                    fd_var[] gsvars = new fd_var[2];
                    gsvars[0]=moves[move];
                    gsvars[1]=board[move][i];
                    cons_used_here cons= new cons_used_here(gsvars, prob, p1);}
                }
                /*
                for(int i=0; i<9; i++)
                {
                    omove_predicate p1=new omove_predicate(i);
                    variable[] gsvars = new variable[4];
                    gsvars[0]=board[move-1][i];
                    gsvars[1]=moves[move];
                    gsvars[2]=board[move][i];
                    gsvars[3]=ocheats[move];
                    cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                }*/
            }
            
            // detect lines and map onto appropriate xline or oline var.
            
            if(move==4 || move==6 || move==8)
            {
                // x can win by move 4, so start checking for lines here.
                
                xline_predicate p1=new xline_predicate();
                variable[] gsvars= new variable[10];
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                
                gsvars[9]=xline[move];
                
                cons_used_here cons= new cons_used_here(gsvars, prob, p1);
                
                //  not owins[move-1] and xline[move] <=> xwins[move] and not owins[move]
                // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1]
            }
            
            if(move==5 || move==7)
            {
                // o can win by move 5, so start checking for lines here.
                
                oline_predicate p1=new oline_predicate();
                variable[] gsvars= new variable[10];
                
                for(int i=0; i<9; i++)
                {
                    gsvars[i]=board[move][i];
                }
                
                gsvars[9]=oline[move];
                
                gac_schema_predicate2 cons= new gac_schema_predicate2(gsvars, prob, p1);
            }
            
            if(move>=1)  // from move 1 something can happen i.e. o can cheat.
            {
                variable[] tempvars= new variable[4];
                tempvars[0]=winstate[move-1];
                tempvars[1]=xline[move];
                tempvars[2]=oline[move];
                tempvars[3]=winstate[move];
                
                logic_predicate p2=new logic_predicate();
                cons_used_here cons2= new cons_used_here(tempvars, prob, p2);
            }
            
            // moves where o cheats should be pure, so don't forget the pure literal rule!!
            //prob.printdomains();
        }
        
        // make the last two move variables
        
        moves[6]=new existential(3, prob, "move6");
        prob.addvar(moves[6]);
        
        moves[7]=new universal(2, prob, "move7");
        prob.addvar(moves[7]);
        
        // make the big end constraint
        // last three moves -- last move is unit.
        
        
        {variable [] tempvar=new variable[12];
        System.arraycopy(board[5], 0, tempvar, 0, 9);
        tempvar[9]=winstate[5];
        
        tempvar[10]=moves[6];
        tempvar[11]=moves[7];
        
        //for(int i=0; i<tempvar.length; i++)
        //    System.out.println(tempvar[i]+" ");
        
        System.out.println();
        
        lastmoves_predicate p1=new lastmoves_predicate();
        
        cons_used_here cons= new cons_used_here(tempvar, prob, p1);}
        
        // root node processing here.
        
        StopWatch sw= new StopWatch("GMT");
        sw.start();
        prob.establish_gac();
        
        // set some variables
        
        winstate[0].exclude(0, null);
        //winstate[0].exclude(1, null);
        xline[0].exclude(1, null);
        oline[0].exclude(1, null);
        
        xline[1].exclude(1, null);
        oline[1].exclude(1, null);
        
        xline[2].exclude(1, null);
        oline[2].exclude(1, null);
        
        xline[3].exclude(1, null);
        oline[3].exclude(1, null);
        
        // move 4 -- x line can happen now
        oline[4].exclude(1, null);
        
        xline[5].exclude(1, null);
        
        /*
        // symmetry breaking
        board[0][2].instantiate(2, null);
        board[0][3].instantiate(2, null);
        board[0][5].instantiate(2, null);
        board[0][6].instantiate(2, null);
        board[0][7].instantiate(2, null);
        board[0][8].instantiate(2, null);
        */
        prob.backtrack.add_backtrack_level();
        
        prob.propagate();
        
        sw.end();
        System.out.println("Setup time: "+sw.elapsedMillis());
        
        //prob.printdomains();
        
        System.out.println(prob.blocks);
        
        //System.out.println(
        sw= new StopWatch("GMT");
        
        sw.start();
        System.out.println(prob.search());
        sw.end();
        System.out.println("Search time: "+sw.elapsedMillis()+" , Nodes:"+prob.numnodes);
        
        
        //System.out.println(cons);
    }
}

class xline_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // first 9 entries in tau are the board, and the tenth is a 0/1 variable indicating if player 0 has won.
        
        if( (tau.vals[0]==0 && tau.vals[1]==0 && tau.vals[2]==0)
        || (tau.vals[3]==0 && tau.vals[4]==0 && tau.vals[5]==0)
        || (tau.vals[6]==0 && tau.vals[7]==0 && tau.vals[8]==0)
        
        // verticals
        || (tau.vals[0]==0 && tau.vals[3]==0 && tau.vals[6]==0)
        || (tau.vals[1]==0 && tau.vals[4]==0 && tau.vals[7]==0)
        || (tau.vals[2]==0 && tau.vals[5]==0 && tau.vals[8]==0)
        
        // diagonals
        || (tau.vals[0]==0 && tau.vals[4]==0 && tau.vals[8]==0)
        || (tau.vals[2]==0 && tau.vals[4]==0 && tau.vals[6]==0) )
        {
            // so x has a line
            if(tau.vals[9]==1)
            {
                return true;
            }
            else
            {
                assert tau.vals[9]==0;
                return false;
            }
        }
        else
        {
            // x does not have a line
            if(tau.vals[9]==1)
            {
                return false;
            }
            else
            {
                assert tau.vals[9]==0;
                return true;
            }
        }
    }
}

class oline_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // first 9 entries in tau are the board, and the tenth is a 0/1 variable indicating if player 0 has won.

        if( (tau.vals[0]==1 && tau.vals[1]==1 && tau.vals[2]==1)
        || (tau.vals[3]==1 && tau.vals[4]==1 && tau.vals[5]==1)
        || (tau.vals[6]==1 && tau.vals[7]==1 && tau.vals[8]==1)

        // verticals
        || (tau.vals[0]==1 && tau.vals[3]==1 && tau.vals[6]==1)
        || (tau.vals[1]==1 && tau.vals[4]==1 && tau.vals[7]==1)
        || (tau.vals[2]==1 && tau.vals[5]==1 && tau.vals[8]==1)

        // diagonals
        || (tau.vals[0]==1 && tau.vals[4]==1 && tau.vals[8]==1)
        || (tau.vals[2]==1 && tau.vals[4]==1 && tau.vals[6]==1) )
        {
            // so o has a line
            if(tau.vals[9]==1)
            {
                return true;
            }
            else
            {
                assert tau.vals[9]==0;
                return false;
            }
        }
        else
        {
            // o does not have a line
            if(tau.vals[9]==1)
            {
                return false;
            }
            else
            {
                assert tau.vals[9]==0;
                return true;
            }
        }
    }
}

class logic_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {
        // connect  xline[move]. xwins[move] and owins[move] to xwins[move-1] and owins[move-1]
        
        //tempvars[0]=winstate[move-1];
        //tempvars[1]=xline[move];
        //tempvars[2]=oline[move];
        //tempvars[3]=winstate[move];
        
        if(tau.vals[0]==0)  // if x won last move, ensure that x wins this move
        {
            return tau.vals[3]==0;
        }
        
        if(tau.vals[0]==1)  // if o won last move, ensure that o wins this move
        {
            return tau.vals[3]==1;
        }
        
        // neither player won last move.
        
        if(tau.vals[1]==1)
        {
            // x wins with a line
            return tau.vals[3]==0;
        }
        else
        {
            if(tau.vals[2]==1)
            {
                // o wins with a line
                return tau.vals[3]==1;
            }
            else
            {
                // neither wins
                return tau.vals[3]==2;
            }
        }
    }
}

class xmove_predicate extends predicate_wrapper
{
    final int pos;
    
    xmove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[1]) to oldboard position [0] and newboard position [2]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            // this is the existential player so we want to prune the cheating moves.
            return (tau.vals[0]==2 && tau.vals[2]==0);
        }
        else
        {
            return tau.vals[0]==tau.vals[2];
        }
    }
}

// requires both normal and special

class omove_special_predicate extends predicate_wrapper
{
    final int pos;
    
    omove_special_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect old board position tau[0] to move (tau[1]) and newboard position tau[2]
        
        // board places are   0=x 1=o 2=empty
        
        if(tau.vals[1]==pos)
        {
            // if this position is being changed
            
            return tau.vals[0]==2;
        }
        else
        {
            // otherwise propagate the old value forward
            return tau.vals[0]==tau.vals[2];
        }
    }
}

class omove_normal_predicate extends predicate_wrapper
{
    final int pos;
    
    omove_normal_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect  move [0] and to newboard position [1]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        if(tau.vals[0]==pos)
        {
            // if this position is being changed
            return tau.vals[1]==1;
        }
        
        return true;
    }
}

class firstxmove_predicate extends predicate_wrapper
{
    final int pos;
    
    firstxmove_predicate(int pos)
    {
        this.pos=pos;
    }
    
    public boolean predicate(tuple tau)
    {
        // connect move (tau[1]) to newboard position [0]
        
        // board places are   0=x 1=o 2=empty
        
        // x place is denoted by board[i]==0
        
        if(tau.vals[1]==pos)
        {
            return (tau.vals[0]==0);
        }
        else
        {
            return tau.vals[0]==2;
        }
    }
}

class lastmoves_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {   
        // tau[0..8] is boardstate before
        // tau[9] is winstate before
        // tau[10] is move7 (existential)
        // tau[11] is move8 (universal)
        
        int [] vals=tau.vals;
        
        if(vals[9]!=2)    // if someone has already won, this cons is satisfied iff it is the first player.
            return vals[9]==0;
        
        int move1=vals[10];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move1++;
            }
            
            if(move1<=i)
            {
                break;
            }
        }
        
        int move2=vals[11];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move2++;
            }
            
            if(move2==move1)
            {
                move2++;
            }
            
            if(move2<=i)
            {
                break;
            }
        }
        
        // move1 and move2 should now be in 0..8
        
        // if either have gone over the limit, the boardstate is seriously flawed so
        // just reject it.
        if(move1>8 || move2>8)
            return false; 
        
        // copy to be sure we don't alter the tuple
        int [] board=new int[9];
        for(int i=0; i<9; i++)
            board[i]=vals[i];
        
        assert board[move1]==2;
        
        board[move1]=0;
        
        // if x has won after move1, then return true.
        
        if( (board[0]==0 && board[1]==0 && board[2]==0)
        || (board[3]==0 && board[4]==0 && board[5]==0)
        || (board[6]==0 && board[7]==0 && board[8]==0)
        
        // verticals
        || (board[0]==0 && board[3]==0 && board[6]==0)
        || (board[1]==0 && board[4]==0 && board[7]==0)
        || (board[2]==0 && board[5]==0 && board[8]==0)
        
        // diagonals
        || (board[0]==0 && board[4]==0 && board[8]==0)
        || (board[2]==0 && board[4]==0 && board[6]==0) )
        {
            return true;
        }
        
        // if o has won after move2, then return false;
        
        assert board[move2]==2;
        board[move2]=1;
        
        if( (board[0]==1 && board[1]==1 && board[2]==1)
        || (board[3]==1 && board[4]==1 && board[5]==1)
        || (board[6]==1 && board[7]==1 && board[8]==1)
        
        // verticals
        || (board[0]==1 && board[3]==1 && board[6]==1)
        || (board[1]==1 && board[4]==1 && board[7]==1)
        || (board[2]==1 && board[5]==1 && board[8]==1)
        
        // diagonals
        || (board[0]==1 && board[4]==1 && board[8]==1)
        || (board[2]==1 && board[4]==1 && board[6]==1) )
        {
            return false;
        }
        
        // find and fill in the one remaining empty slot, then test again if 
        // x has won.
        
        for(int i=0; i<9; i++)
        {
            if(board[i]==2){ board[i]=0; break; }
        }
        
        if( (board[0]==0 && board[1]==0 && board[2]==0)
        || (board[3]==0 && board[4]==0 && board[5]==0)
        || (board[6]==0 && board[7]==0 && board[8]==0)
        
        // verticals
        || (board[0]==0 && board[3]==0 && board[6]==0)
        || (board[1]==0 && board[4]==0 && board[7]==0)
        || (board[2]==0 && board[5]==0 && board[8]==0)
        
        // diagonals
        || (board[0]==0 && board[4]==0 && board[8]==0)
        || (board[2]==0 && board[4]==0 && board[6]==0) )
        {
            return true;
        }
        
        // it's a draw.
        
        return false;
    }
}

class filtermoves_predicate extends predicate_wrapper
{
    public boolean predicate(tuple tau)
    {   
        // channel one move variable into another.
        
        // tau[0..8] is boardstate before
        // tau[9] is movevar1
        // tau[10] is movevar2
        
        int [] vals=tau.vals;
        
        int move1=vals[9];
        
        for(int i=0; i<9; i++)
        {
            if(vals[i]!=2)
            {
                move1++;
            }
            
            if(move1<=i)
            {
                break;
            }
        }
        
        // broken boardstate
        if(move1>8)
            return false;
        
        return vals[10]==move1;
    }
}
