abstract class rat_var extends variable
{
    rat_var(IntFraction lowerbound, IntFraction upperbound, qcsp problem, boolean quant, String name)
    {
        super(problem, quant, name);
        
        assert lowerbound.compare(upperbound)==-1;  // lowerbound<upperbound
        
        wakeups_upper=new ArrayList<constraint>();
        wakeups_lower=new ArrayList<constraint>();
        
        this.lowerbound=lowerbound;
        this.upperbound=upperbound;
    }
    
    // includes the bounds
    
    IntFraction upperbound;
    IntFraction lowerbound;
    
    ArrayList<constraint> wakeups_upper;
    ArrayList<constraint> wakeups_lower;
    
    boolean is_present(IntFraction val)
    {
        // not really a dumb getter method, but intended to provide some abstraction from
        // the bounds
        
        return val.compare(lowerbound)!=-1 && val.compare(upperbound)!=1;  
        // not less than lowerbound and not greater than upperbound.
    }
    
    boolean unit()
    {
        return lowerbound.compare(upperbound)==0;
    }
    
    boolean empty()
    {
        return lowerbound.compare(upperbound)==1;
    }
    
    // low-level events, not seen by the consistency algorithms.
    // Backtracking happens at this level.
    
    boolean revise_upper(IntFraction val)
    {
        assert val.compare(upperbound)==-1;
        
        problem.backtrack.rat_var.add_backtrack_upper(this.id, upperbound);
        upperbound=val;
        
        if(lowerbound.compare(upperbound)==1) // lb>ub
            return false;
        else
            return true;
    }
    
    // from here
    
    boolean revise_lower(IntFraction val)
    {
        assert val.compare(lowerbound)==1;
        
        problem.backtrack.rat_var.add_backtrack_lower(this.id, lowerbound);
        lowerbound=val;
        
        if(lowerbound.compare(upperbound)==1)
            return false;
        else
            return true;
    }
    
    void unrevise_upper(IntFraction val)
    {
        assert val.compare(upperbound)==1;
        upperbound=val;
    }
    
    void unrevise_lower(IntFraction val)
    {
        assert val.compare(lowerbound)==-1;
        lowerbound=val;
    }
    
    // for use by consistency algorithms
    abstract boolean exclude_upper(IntFraction val, constraint cons);   // anything greater than val is locally inconsistent
    abstract boolean exclude_lower(IntFraction val, constraint cons);
    //abstract void pure(int val, constraint cons);    // val is pure, should always succeed.
    
    // for use by search procedure
    //abstract void instantiate(int val);  // void because it should always succeed
}

class rat_existential extends rat_var
{
    rat_existential(IntFraction lowerbound, IntFraction upperbound, qcsp problem, String name)
    {
        super(lowerbound, upperbound, problem, false, name);
    }
    
    boolean exclude_upper(IntFraction val, constraint cons)
    {
        if(problem.pruning) System.out.println("Reducing upper bound of var "+this+" to "+val);
        
        assert val.compare(upperbound)==-1;  // must be less than the existing bound
        
        if(!revise_upper(val))
        {
            if(problem.treetrace)System.out.println("Empty domain "+this);
            return false;
        }
        
        // Check the wakeups array here
        for(constraint temp : wakeups_upper)
        {
            if(temp!=cons)
            {
                //System.out.println("Adding constraint: "+temp);  // prob.need to change types here.
                if(temp instanceof rat_propagate)   // if it is gac_schema
                    problem.queue.push_constraint((rat_propagate)temp, id, true);
                else
                    problem.queue.push_constraint((make_ac)temp);
                
            }
        }
        
        return true;
    }
    
    boolean exclude_lower(IntFraction val, constraint cons)
    {
        if(problem.pruning) System.out.println("Increasing lower bound of var "+this+" to "+val);
        
        assert val.compare(lowerbound)==1;  // must be greater than the existing bound
        
        if(!revise_lower(val))
        {
            if(problem.treetrace)System.out.println("Empty domain "+this);
            return false;
        }
        
        // Check the wakeups array here
        for(constraint temp : wakeups_upper)
        {
            if(temp!=cons)
            {
                //System.out.println("Adding constraint: "+temp);  // prob.need to change types here.
                if(temp instanceof rat_propagate)   // if it is gac_schema
                    problem.queue.push_constraint((rat_propagate)temp, id, false);
                else
                    problem.queue.push_constraint((make_ac)temp);
            }
        }
        
        return true;
    }
}

class rat_backtrack_variables extends backtrack
{
    TIntArrayList vars;         // bounds changed in sequence
    TIntArrayList upperlower;   // 0=lower 1=upper
    ArrayList<IntFraction> bounds;   // old bound
    
    qcsp prob;
    
    rat_backtrack_variables(qcsp problem)
    {
        prob=problem;
        vars= new TIntArrayList();
        upperlower= new TIntArrayList();
        
        bounds=new ArrayList<IntFraction>();
    }
    
    final void add_backtrack_upper(int var, IntFraction bound)
    {
        vars.add(var);
        upperlower.add(1);
        bounds.add(bound);
        
        backtrack_increment();
    }
    
    final void add_backtrack_lower(int var, IntFraction bound)
    {
        vars.add(var);
        upperlower.add(0);
        bounds.add(bound);
        
        backtrack_increment();
    }
    
    void backtrack_item(int index)
    {
        int var=vars.remove(index);
        int ul=upperlower.remove(index);
        IntFraction b=bounds.remove(index);
        if(ul==0)
        {
            ((rat_var)prob.variables.get(var)).unrevise_lower(b);
        }
        else
        {
            ((rat_var)prob.variables.get(var)).unrevise_upper(b);
        }
    }
}
