//------------------------------------------------------------------------------------------
// gac_schema_predicate which can prune from universals without failing, therefore act like a pure value rule.
import java.util.*;
import gnu.trove.*;

class gac_schema_predicate_special extends gac_schema
{
    
    // overrides the two methods where exclude is called.
    
    
    final predicate_wrapper pred;
    
    // the returns for the function nextTuple
    // not thread-safe.
    static tuple returnsigma;
    static int returnkprime;
    
    // Three possible outcomes:
    // 1: AC established, keep constraint
    // 2: AC established, discard constraint
    // 3: Fail
    gac_schema_predicate_special(variable[] var, qcsp prob, predicate_wrapper pred)
    {
        //super(var, prob);
        
        //hackathon: this is the constraint constructor
        
        this.variables=var;
        this.problem=prob;
        
        // sanity check
        for(int i=1; i<variables.length; i++)
        {
            if(variables[i-1].blocknumber>variables[i].blocknumber)
            {
                System.out.println("New sanity check: Either variables in wrong order, or some not present in problem instance.");
            }
        }
        
        problem.addcons(this);
        //end
        
        num_uni_inside = new int[variables.length];
        
        int num_universals=0;
        
        for(int i=0; i<variables.length; i++)
        {
            if(false) // variables[i].quant)
            {
                // add one to all the outside ones
                for(int j=0; j<i; j++)
                    num_uni_inside[j]++;
            }
            
            if(false) //variables[i].quant)
                num_universals++;
        }
        
        // set the initial capacity -- O(d^r) is the upper bound on the number of keys.
        // Could be a vast overestimate. maxdomsize^num_universals
        
        supports_current=new THashMap(); //<pa, linktuple>
        literals_by_support=new THashMap(); //<tuple, LinkedList<pa>>
        last_support=new THashMap(); //<pa, tuple>
        
        // and the backtrack objects
        supports_current_b=new supports_current_backtrack(this);
        literals_by_support_b=new literals_by_support_backtrack(this);
        last_support_b=new last_support_backtrack(this);
        
        this.pred=pred;
    }
    
    public int propagate(int problem_var, int val)
    {        
        // problem_var is an index into the problem variable array.
        int var=variables[0].id;
        
        for(int i=0; i<variables.length; i++)
        {
            if (problem_var==variables[i].id)
            {
                var=i;
                break;
            }
        }
        
        // var, val is the pair removed.
        
        //System.out.println("Propagate called for "+var+", "+val);
        
        int[] tempvars=new int[num_uni_inside[var]+1];
        int[] tempvals=new int[num_uni_inside[var]+1];
        tempvars[0]=var;
        tempvals[0]=val;
        
        ArrayList<pa> list=new ArrayList<pa>();
        
        generate_pa(list, var+1, 1, tempvars, tempvals);
        
        // for each pa which contains (var, val) as its first entry
        for(pa supports_current_key : list)
        {
            // Make a copy because it could change.
            
            linktuple temp = (linktuple) supports_current.get(supports_current_key);
            ArrayList<tuple> sc = new ArrayList<tuple>();
            //System.out.println(supports_current_key);
            
            {tuple tau=temp.first();
            while(tau!=null)
            {
                sc.add(tau);
                tau=temp.next(tau);
            }}
            
            // for each tuple containing (var, val) which is currently used as a 
            // first support somewhere (since it is in supports_current)
            
            for(tuple tau : sc)
            {
                // tau is no longer valid.
                
                // for each (z,c) in tau remove tau from supports_current(z,c,...)
                
                pa [] palist=find_supported_pa(tau);
                
                //System.out.println("Retiring tuple tau:"+tau);
                
                for(int i=0; i<palist.length; i++)
                {
                    assert supports_current.containsKey(palist[i]);
                    
                    //System.out.println("supported pa:"+palist[i]);
                    //System.out.println("tau:"+tau);
                    linktuple lt=(linktuple)supports_current.get(palist[i]);
                    
                    if(lt.in(tau))
                    {
                        lt.remove(tau);
                        supports_current_b.add_removal(palist[i], tau);
                    }
                }
                
                // Look up the pa's which had tau as their first support.
                
                linkpa partiallist=(linkpa)literals_by_support.get(tau);
                
                // make copy here
                ArrayList<pa> taufirstsupport = new ArrayList<pa>();
                
                {pa partial=partiallist.pop();
                while(partial!=null)
                {
                    taufirstsupport.add(partial);
                    literals_by_support_b.add_removal(tau, partial);
                    partial=partiallist.pop();
                }}
                
                for(pa partial : taufirstsupport)
                {
                    // Check this partial is still valid against current domains.
                    boolean valid=true;
                    for(int i=0; i<partial.vars.length; i++)
                    {
                        if(!variables[partial.vars[i]].is_present(partial.vals[i]))  // if pruned
                        {
                            valid=false;
                            break;
                        }
                    }
                    
                    // if partial is valid then seek support for it.
                    if(valid)
                    {
                        tuple sigma=seekInferableSupport(partial);
                        if(sigma!=null)
                        {
                            // add partial to literals_by_support(sigma)
                            // because sigma has become the primary support for partial.
                            //System.out.println("Adding support by seekInferableSupport");
                            ((linkpa)literals_by_support.get(sigma)).insert_end(partial);
                            literals_by_support_b.add_addition(sigma, partial);
                            assert satisfies(sigma, partial);
                        }
                        else
                        {
                            sigma=seekNextSupport(partial, (tuple)last_support.get(partial));
                            if(sigma!=null)
                            {
                                // add partial in literals_by_support.
                                if(literals_by_support.containsKey(sigma))
                                {
                                    ((linkpa)literals_by_support.get(sigma)).insert_end(partial);
                                }
                                else
                                {
                                    linkpa temppalist=new linkpa();
                                    temppalist.insert_end(partial);
                                    literals_by_support.put(sigma, temppalist);
                                    
                                }
                                // store backtracking info
                                literals_by_support_b.add_addition(sigma, partial);
                                assert satisfies(sigma, partial);
                                
                                // update last_support
                                // first record backtracking info
                                last_support_b.add_action(partial, (tuple)last_support.get(partial));
                                last_support.put(partial, sigma);
                                
                                // for all pa supported by sigma, add sigma in supports_current(pa)
                                palist=find_supported_pa(sigma);
                                for(int i=0; i<palist.length; i++)
                                {
                                    ((linktuple)supports_current.get(palist[i])).insert_end(sigma);
                                    supports_current_b.add_addition(palist[i], sigma);
                                }
                            }
                            else
                            {
                                //System.out.println("Attempting to prune "+variables[partial.vars[0]]+" value "+partial.vals[0]);
                                //System.out.println("Constraint "+this);
                                //System.out.println("Attempting to prune "+variables[partial.vars[0]]+" value "+partial.vals[0]);
                                
                                // changed from here to avoid failing on universals.
                                
                                variable myvar=variables[partial.vars[0]];
                                if(myvar instanceof universal)
                                {
                                    // check if this is the last value
                                    /*int count=0;
                                    for(int i=0; i<myvar.hash.length; i++)
                                    {
                                        if(myvar.hash[i]==0)
                                            count++;
                                    }
                                    assert count>1;*/
                                    
                                    ((universal)myvar).pure(partial.vals[0], this);  // this isn't really a pure value so be 
                                    // careful with the semantics here.
                                }
                                else if(!myvar.exclude(partial.vals[0], this))
                                {
                                    return 3;  //fail
                                }
                            }
                        }
                    }
                    //partial=partiallist.pop();
                    //if (partial!=null) literals_by_support_b.add_removal(tau, partial);
                    //partial=partial.next;  // this is incorrect because the item needs to be removed;
                    // because otherwise list pointers get overwritten.
                }
            }
        }
        return 1;
    }
    
    void generate_pa(ArrayList<pa> list, int currentvar, int index, int[] tempvars, int [] tempvals)
    {
        // base case
        if(currentvar==variables.length)
        {
            list.add(new pa((int [])tempvars.clone(), (int [])tempvals.clone()));
        }
        // recursive case
        else
        {
            if(false)//variables[currentvar].quant)
            {
                for(int i=variables[currentvar].lowerbound; i<=variables[currentvar].upperbound; i++)
                {
                    if(variables[currentvar].is_present(i))
                    {// if not pruned
                        tempvars[index]=currentvar;
                        tempvals[index]=i;
                        generate_pa(list, currentvar+1, index+1, tempvars, tempvals);
                    }
                }
            }
            else
            {
                generate_pa(list, currentvar+1, index, tempvars, tempvals);
            }
        } 
    }
    
    pa[] find_supported_pa(tuple sigma)
    {
        // find all the pa's supported by sigma.
        // Iterate from the innermost to the outermost literal, retaining universals as you go.
        
        pa[] palist = new pa[variables.length];
        
        int retained=sigma.vals.length;  // fill in the arrays from the end.

        int [] retained_vars = new int[variables.length];
        int [] retained_vals = new int[variables.length];

        for(int i=variables.length-1; i>=0; i--)
        {
            int [] tempvars = new int[variables.length-retained+1];
            int [] tempvals = new int[variables.length-retained+1];

            tempvars[0]=i;
            tempvals[0]=sigma.vals[i];

            // copy the retained universal assignments (if any)
            for(int j=retained; j<variables.length; j++)
            {
                tempvars[j-retained+1]=retained_vars[j];
                tempvals[j-retained+1]=retained_vals[j];
            }
                        
            palist[i]= new pa(tempvars, tempvals);
            
            if(false)//variables[i].quant)
            {
                // if the ith variable is universal then add it on the end of retained_array
                retained--;
                retained_vars[retained]=i;
                retained_vals[retained]=sigma.vals[i];
            }
        }
        return palist;
    }
    
    public boolean establish_gac()
    {
        // set up the current supports, and literals by support
        // Whatever happens here and in find_support is not backtrackable
        
        for(int i=0; i<variables.length; i++)
        {
            for(int j=0; j<variables[i].wakeups.length; j++)
            {
                variables[i].wakeups[j].add(this);
                //System.out.println("Added something to a wakeup");
            }
        }
        
        for(int var=0; var<variables.length; var++)
        {
            //System.out.println("Processing variable "+variables[var].name);
            //System.out.println("num_uni_inside:"+num_uni_inside[var]);
            
            int [] pavars= new int[num_uni_inside[var]+1];
            int [] pavals= new int[num_uni_inside[var]+1];
            
            for(int val=0; val<variables[var].domsize(); val++)
            {
                if(variables[var].is_present(val))    // untested change.
                {
                    pavars[0]=var;
                    pavals[0]=val;
                    if(!find_support(var+1, 1, pavars, pavals))
                    {
                        //System.out.println("Constraint "+this);
                        //System.out.println("Pruning value " + val);
                        
                        // changed from here to avoid failing on universals
                        
                        variable myvar=variables[var];
                        if(myvar instanceof universal)
                        {
                            // check if this is the last value
                            /*int count=0;
                            for(int i=0; i<myvar.hash.length; i++)
                            {
                                if(myvar.hash[i]==0)
                                    count++;
                            }
                            assert count>1;*/
                            
                            ((universal)myvar).pure(val, this);
                            // this isn't really a pure value so be careful here
                        }
                        else if(!myvar.exclude(val, this))  // change 'this' to null if you want removals to be queued for propagation on this constraint.
                        {
                            return false;
                        }
                    }
                }
            }
        }
        
        // if removals have been made during this initial phase, the
        // constraint queue should now have the appropriate calls to
        // propagate queued up.
        
        return true;
    }
    
    boolean find_support(int currentvar, int papos, int [] pavars, int [] pavals)
    {
        // currentvar is 0,1,2... for indexing the arrays
        
        // This function can only be used the first time, when an
        // assignment has no linked list of supports.
        
        // base case 
        
        if(currentvar==variables.length)
        {
            // pa is complete
            
            // make a copy so that tau will not be changed in later recursions
            int [] pavarscopy= (int [])pavars.clone();  // System.arraycopy may be faster.
            int [] pavalscopy= (int [])pavals.clone();
            
            pa tau=new pa(pavarscopy, pavalscopy);
            
            // Check it is not already supported
            
            //System.out.println("Checking partial assignment:");
            //System.out.println(tau);
            
            if(supports_current.containsKey(tau))
            {
                //System.out.println("Already supported");
                return true;
            }
            else
            {
                // Seek the first support for this value.
                //System.out.println("Seeking first support");
                tuple support=seekNextSupport(tau, null);
                
                // record this in lastc / last_support
                last_support.put(tau, support);
                
                if(support==null)
                {
                    return false;
                }
                else
                {
                    // add support to all supported partial assignments
                    
                    pa [] palist=find_supported_pa(support);
                    
                    for(int i=0; i<palist.length; i++)
                    {
                        if(supports_current.containsKey(palist[i]))
                        {
                            ((linktuple) supports_current.get(palist[i])).insert_end(support);
                        }
                        else
                        {
                            //System.out.println("Making new linktuple with id:"+palist[i].vars[0]);
                            linktuple temptuplelist=new linktuple(palist[i].vars[0]);   //careful here if adapting for SQGAC
                            temptuplelist.insert_end(support);
                            supports_current.put(palist[i], temptuplelist);
                            
                            // Since support is the first support for temppa, add support -> temppa to literals_by_support
                            
                            if(literals_by_support.containsKey(support))
                            {
                                ((linkpa)literals_by_support.get(support)).insert_end(palist[i]);
                            }
                            else
                            {
                                linkpa temppalist= new linkpa();
                                temppalist.insert_end(palist[i]);
                                literals_by_support.put(support, temppalist);
                            }
                        }
                    }
                    
                    return true;
                }
            }
        }
        
        // recursive case
        // changed from here to assume all variables are existential
        /*if(variables[currentvar].quant)
        {
            // currentvar is universal so we need to branch.
            
            //System.out.println(pavars.length+" "+currentvar+" "+papos);
            pavars[papos]=currentvar;
            
            //System.out.println("Number of values to branch on:"+ variables[currentvar].hash.length);
            
            for(int val=0; val<variables[currentvar].hash.length;  val++)
            {
                // branch for val
                //System.out.println("Branching for value "+val);
                pavals[papos]=val;
                if( !find_support(currentvar+1, papos+1, pavars, pavals))
                    return false;
                
            }
            
            return true;
        }
        else
        {*/
            // currentvar is existential, so just increment currentvar
            return find_support(currentvar+1, papos, pavars, pavals);
        //}
    }
    
    void add_backtrack_level()
    {
        // Intended to be called by the search algorithm whenever we go to a new node.
        supports_current_b.add_backtrack_level();
        literals_by_support_b.add_backtrack_level();
        last_support_b.add_backtrack_level();
        // and for the other data structures.
    }
    
    void backtrack()
    {
        // Intended to be called when the search algorithm backtracks.
        supports_current_b.backtrack();
        literals_by_support_b.backtrack();
        last_support_b.backtrack();
    }
    
    // -----------------------
    // instantiation methods
    
    tuple seekCandidateTuple(pa partial, tuple sigma, int k)
    {
        // again k is the index counting from 0 here whereas in the paper it is from 1
        while(sigma!=null && k<variables.length)
        {
            // sigma is candidate till index k
            
            // Construct the partial assignment corresponding to the literal var(k)=k
            // and all inner universals from sigma.
            
            int [] tempvars= new int[num_uni_inside[k]+1];
            int [] tempvals= new int[num_uni_inside[k]+1];
            
            tempvars[0]=k;
            tempvals[0]=sigma.vals[k];
            
            // copy inner universals.
            int tempvarspointer=1;
            
            for(int i=k+1; i<sigma.vals.length; i++)
            {
                if(false)//variables[i].quant)
                {
                    tempvars[tempvarspointer]=i;
                    tempvals[tempvarspointer]=sigma.vals[i];
                    tempvarspointer++;
                }
            }
            
            assert tempvarspointer==tempvars.length;
            
            pa temppa= new pa(tempvars, tempvals);
            
            //System.out.println("In seekCandidateTuple: temppa = "+temppa);
            
            tuple lambda=(tuple)last_support.get(temppa);
            
            if(lambda!=null)
            {
                int split=0;   // index from 0 unlike paper.
                while(split<sigma.vals.length && sigma.vals[split]==lambda.vals[split])  //split<sigma.vals.length && 
                {
                    split++;
                }
                
                // we should never have sigma==lambda
                //System.out.println("In seekCandidateTuple: split:"+split+" sigma:"+sigma+" lambda:"+lambda);
                
                // lambda is lessthan or equal to sigma so jump forward.
                if(split==sigma.vals.length || sigma.vals[split]<lambda.vals[split]) //split==sigma.vals.length || 
                {
                    if(split<k)
                    {
                        nextTuple(partial, sigma, k);
                        k=returnkprime-1;
                        sigma=returnsigma;
                    }
                    else
                    {
                        nextTuple(partial, lambda, lambda.vals.length-1);
                        
                        // k= min(k, k'-1);
                        if(k>(returnkprime-1))
                        {
                            k=(returnkprime-1);
                        }
                        
                        sigma=returnsigma;
                    }
                }
            }
            
            k++;
        }
        return sigma;
    }
    
    tuple seekNextSupport(pa partial, tuple previous_support)
    {
        tuple new_support;
        
        if(previous_support!=null)
        {
            //System.out.println("Calling 1");
            nextTuple(partial, previous_support, variables.length-1);
            new_support=returnsigma;
        }
        else
        {
            int [] tuplearray=new int[variables.length];
            int partialindex=0;
            
            for(int i=0; i<variables.length; i++)
            {
                variable v=variables[i];
                
                if(partialindex<partial.vars.length && partial.vars[partialindex] == i)
                {
                    tuplearray[i]=partial.vals[partialindex];
                    partialindex++;
                    continue;
                }
                
                //  lowest valid value
                tuplearray[i]=v.lowerbound;
            }
            new_support=new tuple(tuplearray);
        }
        
        new_support = seekCandidateTuple(partial, new_support, 1);
        
        while(new_support!=null)
        {
            if(pred.predicate(new_support)) 
            {
                return new_support;
            }
            else
            {
                //System.out.println("Calling 2");
                nextTuple(partial, new_support, variables.length-1);
                
                new_support=seekCandidateTuple(partial, returnsigma, returnkprime);
            }
        }
        
        return new_support;
    }
    
    void nextTuple(pa partial, tuple old, int k)
    {
        // intended to return the lex-smallest valid tuple sigma >lo old, and matching partial, and sigma[0..k]!=old[0..k]
        // warning: k is the index from 0 here. In the Bessiere and Regin paper it is an index from 1.
        
        // System.out.println("nextTuple called with partial "+partial+" and old tuple "+old+"and k="+k);
        
        int [] tuplearray = new int[variables.length];
        
        // copy
        for(int i=0; i<variables.length; i++)
        {
            tuplearray[i] = old.vals[i];
        }
        
        // impose partial and the current domains until the most significant changed digit less than k.
        
        int partialpointer=0;
        
        for(int i=0; i<=k; i++)
        {
            while(partialpointer<partial.vars.length && partial.vars[partialpointer]<i)
                partialpointer++;
            
            // if the partial assignment changes the tuple:
            if(partialpointer<partial.vars.length && partial.vars[partialpointer]==i)
            {
                if(partial.vals[partialpointer]>tuplearray[i])
                {
                    tuplearray[i]=partial.vals[partialpointer];
                    zerorest(partial, tuplearray, i+1);
                    returnsigma=new tuple(tuplearray);
                    returnkprime=i;
                    return;
                }
                else if(partial.vals[partialpointer]<tuplearray[i])
                {
                    tuplearray[i]=partial.vals[partialpointer];
                    // slot i is less, so slots 0-- i-1 must be lex greater than the old tuple.
                    if(!countup(partial, tuplearray, i-1))
                    {
                        returnsigma=null;
                        returnkprime=0;
                        return;
                    }
                    else
                    {
                        int kprime=0;
                        for(; kprime<variables.length; kprime++)
                        {
                            if(tuplearray[kprime]!=old.vals[kprime])
                            {
                                break;
                            }
                        }
                        returnsigma=new tuple(tuplearray);
                        returnkprime=kprime;
                        return;
                    }
                }
            }
            
            // if the current value is not present in the domain.
            if(!variables[i].is_present(tuplearray[i]))
            {
                // then count up from the current value, 
                // since this prefix must be greater than the old.
                
                if(!countup(partial, tuplearray, i))
                {
                    returnsigma=null;
                    returnkprime=0;
                    return;
                }
                else
                {
                    int kprime=0;
                    for(; kprime<variables.length; kprime++)
                    {
                        if(tuplearray[kprime]!=old.vals[kprime])
                        {
                            break;
                        }
                    }
                    returnsigma=new tuple(tuplearray);
                    returnkprime=kprime;
                    return;
                }
            }
        }
        
        // neither the partial assignment nor the current domains caused the prefix 0..k to
        // be changed. Therefore count up to increase 0..k.
        
        // may need to set the partial here (no because zerorest now sets partial as it goes).
        
        if(!countup(partial, tuplearray, k))
        {
            returnsigma=null;
            returnkprime=0;
            return;
        }
        else
        {
            int kprime=0;
            for(; kprime<variables.length; kprime++)
            {
                if(tuplearray[kprime]!=old.vals[kprime])
                {
                    break;
                }
            }
            returnsigma=new tuple(tuplearray);
            returnkprime=kprime;
            return;
        }
    }
    
    boolean countup(pa partial, int [] tuplearray, int k)
    {
        // start counting up at position k
        // if k is part of partial, then we need to find some other variable to start counting on.
        
        int index=k;
        int partialpointer=partial.vars.length-1;
        for(; index>=0; index--)
        {
            while(partialpointer>=0 && partial.vars[partialpointer]>index)
            {
                partialpointer--;
            }
            
            if(partialpointer<0 || partial.vars[partialpointer]!=index)
            {
                break;
            }
        }
        
        // if all the variables 0..k are in the partial assignment, we can't meet the requirement that
        // sigma[0..k]!=old[0..k] while honouring partial.
        if(index==-1)
        {
            //System.out.println("countup failed to find another tuple 1");
            return false;
        }
        
        partialpointer=partial.vars.length-1;
        for(; index>=0; index--)
        {
            while(partialpointer>=0 && partial.vars[partialpointer]>index)
            {
                partialpointer--;
            }
            
            if(partialpointer<0 || partial.vars[partialpointer]!=index)
            {
                // set the value to the next higher.
                boolean found=false;
                
                for(int j=tuplearray[index]+1; j<=variables[index].upperbound; j++)
                {
                    if(variables[index].is_present(j))
                    {
                        tuplearray[index]=j;
                        found=true;
                        break;
                    }
                }
                
                if(found)
                {
                    break;
                }
            }
        }
        
        if(index==-1)
        {
            //System.out.println("countup failed to find another tuple 2");
            return false;
        }
        
        // so now we have adjusted the appropriate value in the prefix, 
        // we need to zero (set to least value) all the values after that, honouring partial
        // Really should eliminate this code and call zerorest instead.
        
        zerorest(partial, tuplearray, index+1);
        
        return true;
    }
    
    void zerorest(pa partial, int [] tuplearray, int index)
    {
        // from index onwards, set each entry to its lowest value, respecting partial.
        
        // so now we have adjusted the appropriate value in the prefix, 
        // we need to zero (set to least value) all the values after that, honouring partial
        
        int partialpointer=0;
        
        for(; index<variables.length; index++)
        {
            while(partialpointer<partial.vars.length && partial.vars[partialpointer]<index)
            {
                partialpointer++;
            }
            
            if(partialpointer>=partial.vars.length || partial.vars[partialpointer]!=index)
            {
                // set the value to the least.
                tuplearray[index]=variables[index].lowerbound;
            }
            else
            {
                tuplearray[index]=partial.vals[partialpointer];
            }
        }
    }
}
