/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BooleanConstant;
import savilerow.CmdFlags;
import savilerow.CompoundMatrix;
import savilerow.Container;
import savilerow.EmptyMatrix;
import savilerow.LessEqual;
import savilerow.NumberConstant;
import savilerow.SymbolTable;
import savilerow.TransformDecomposeCumulative;

public class Cumulative
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public Cumulative(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
        super(aSTNode, aSTNode2, aSTNode3, aSTNode4);
    }

    @Override
    public ASTNode copy() {
        return new Cumulative(this.getChild(0), this.getChild(1), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 4; ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in first argument of cumulative: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in second argument of cumulative: " + this);
            return false;
        }
        if (this.getChild(2).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in third argument of cumulative: " + this);
            return false;
        }
        if (this.getChild(3).getDimension() != 0) {
            CmdFlags.println("ERROR: Expected scalar in fourth argument of cumulative: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChildConst(0);
        ASTNode aSTNode2 = this.getChildConst(1);
        ASTNode aSTNode3 = this.getChildConst(2);
        ASTNode aSTNode4 = this.getChild(3);
        if (!(aSTNode instanceof CompoundMatrix)) {
            if (aSTNode instanceof EmptyMatrix) {
                return new LessEqual((ASTNode)NumberConstant.make(0L), aSTNode4);
            }
            return null;
        }
        if (aSTNode.getCategory() == 0 && aSTNode2.getCategory() == 0) {
            return TransformDecomposeCumulative.taskDecomp(aSTNode, aSTNode2, aSTNode3, aSTNode4);
        }
        if (aSTNode4.getBounds().upper < 0L) {
            return new BooleanConstant(false);
        }
        return null;
    }

    @Override
    public ASTNode normalise() {
        int n;
        if (!(this.getChild(0) instanceof CompoundMatrix && this.getChild(1) instanceof CompoundMatrix && this.getChild(2) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            arrayList.add(new Container(this.getChild(0).getChild(n), this.getChild(1).getChild(n), this.getChild(2).getChild(n)));
        }
        n = Cumulative.sortByHashcode(arrayList) ? 1 : 0;
        if (n != 0) {
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get(i).getChild(0));
                arrayList3.add(arrayList.get(i).getChild(1));
                arrayList4.add(arrayList.get(i).getChild(2));
            }
            return new Cumulative(CompoundMatrix.make(arrayList2), CompoundMatrix.make(arrayList3), CompoundMatrix.make(arrayList4), this.getChild(3));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        int n;
        if (!(this.getChild(0) instanceof CompoundMatrix && this.getChild(1) instanceof CompoundMatrix && this.getChild(2) instanceof CompoundMatrix)) {
            return null;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            arrayList.add(new Container(this.getChild(0).getChild(n), this.getChild(1).getChild(n), this.getChild(2).getChild(n)));
        }
        n = Cumulative.sortByAlpha(arrayList) ? 1 : 0;
        if (n != 0) {
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get(i).getChild(0));
                arrayList3.add(arrayList.get(i).getChild(1));
                arrayList4.add(arrayList.get(i).getChild(2));
            }
            return new Cumulative(CompoundMatrix.make(arrayList2), CompoundMatrix.make(arrayList3), CompoundMatrix.make(arrayList4), this.getChild(3));
        }
        return null;
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getChuffedtrans()) {
            bufferedWriter.append("constraint chuffed_cumulative(");
        } else if (CmdFlags.getGecodetrans()) {
            bufferedWriter.append("constraint cumulatives(");
        } else {
            bufferedWriter.append("constraint fzn_cumulative(");
        }
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(2).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(3).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("cumulative(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(3).toMinizinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public String toString() {
        return this.generic_to_string("cumulative");
    }
}

