/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.Cat;
import savilerow.CompoundMatrix;
import savilerow.Flatten;
import savilerow.SymbolTable;

public class ListFunction
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public ListFunction(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public ListFunction(ASTNode[] aSTNodeArray) {
        super(aSTNodeArray);
    }

    @Override
    public ASTNode copy() {
        return new ListFunction(this.getChildrenArray());
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).isRelation() || this.getChild(i).isNumerical()) continue;
            System.out.println("ERROR: list function argument is not integer or Boolean: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChildConst(i);
            int n = aSTNode.getDimension();
            System.out.println(aSTNode + " " + n);
            if (n > 1) {
                arrayList.add(new Flatten(aSTNode));
                continue;
            }
            if (n < 1) {
                arrayList.add(CompoundMatrix.make(aSTNode));
                continue;
            }
            arrayList.add(aSTNode);
        }
        System.out.println("simpl: " + arrayList);
        return new Cat(arrayList);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean isRelation() {
        boolean bl = true;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).isRelation()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isNumerical() {
        return !this.isRelation();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("list(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i));
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

