/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.ASTNode;
import savilerow.ASTNodeC;
import savilerow.BinOp;
import savilerow.CmdFlags;
import savilerow.Divide;
import savilerow.Identifier;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.SMT;
import savilerow.Sat;
import savilerow.Times;

public class MultiplyMapper
extends ASTNodeC {
    public static final long serialVersionUID = 1L;

    public MultiplyMapper(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new MultiplyMapper(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp();
    }

    @Override
    public ASTNode simplify() {
        assert (this.getChild(0).getCategory() <= 3 || this.getChild(0).getCategory() == 20);
        assert (this.getChild(1).getCategory() <= 2 || this.getChild(1).getCategory() == 20);
        if (this.getChild(0).isConstant()) {
            this.detachChildren();
            return new Times(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(1).equals(NumberConstant.make(1L))) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        if (this.getChild(1).equals(NumberConstant.make(0L))) {
            return NumberConstant.make(0L);
        }
        if (this.getChild(0) instanceof MultiplyMapper) {
            this.getChild(0).detachChildren();
            this.getChild(1).setParent(null);
            ASTNode aSTNode = BinOp.makeBinOp("*", this.getChild(1), this.getChild(0).getChild(1));
            return new MultiplyMapper(this.getChild(0).getChild(0), aSTNode);
        }
        return null;
    }

    @Override
    public int polarity(int n) {
        return this.polarity() * (this.getChild(1).getValue() > 0L ? 1 : -1);
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            long l = Times.multiply(intpair.lower, intpair2.lower);
            long l2 = Times.multiply(intpair.upper, intpair2.lower);
            long l3 = Times.multiply(intpair.lower, intpair2.upper);
            long l4 = Times.multiply(intpair.upper, intpair2.upper);
            intpair.lower = Math.min(l, Math.min(l2, Math.min(l3, l4)));
            intpair.upper = Math.max(l, Math.max(l2, Math.max(l3, l4)));
        }
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        long l = this.getChild(1).getValue();
        return Intpair.multIntervalSet(arrayList, l);
    }

    @Override
    public String toString() {
        return "mult(" + this.getChild(0) + ", " + this.getChild(1) + ")";
    }

    @Override
    public boolean hasLiteralEncoding() {
        return true;
    }

    @Override
    public long directEncode(Sat sat, long l) {
        long l2 = this.getChild(1).getValue();
        if (l % l2 != 0L) {
            return -sat.getTrue();
        }
        return this.getChild(0).directEncode(sat, l / l2);
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        long l2 = this.getChild(1).getValue();
        if (l2 > 0L) {
            return this.getChild(0).orderEncode(sat, Divide.div(l, l2));
        }
        long l3 = Divide.divceil(l, l2);
        return -this.getChild(0).orderEncode(sat, l3 - 1L);
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL() && this.canVariableEncode();
    }

    @Override
    public boolean canVariableEncode() {
        return CmdFlags.getUseAuxSMT() && this.getChild(0) instanceof Identifier;
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        if (CmdFlags.getUseLIA() || CmdFlags.getUseNIA()) {
            if (this.getChild(1).getValue() == -1L) {
                return "(- " + this.getChild(0).smtEncodeInt(sMT) + ")";
            }
            return "(* " + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
        }
        if (CmdFlags.getUseIDL() && this.canVariableEncode()) {
            try {
                return sMT.createAuxSMTVariableFor(this.getChild(0), this.getChild(1).getValue());
            }
            catch (IOException iOException) {
                CmdFlags.errorExit("Could not create auxiliary variable for the node " + this.toString() + " because output file could not be accessed");
            }
        }
        CmdFlags.errorExit("Can't encode Int for MultiplyMapper");
        return null;
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        if (this.numChildren() > 2) {
            CmdFlags.errorExit("too many children");
        }
        if (CmdFlags.getUseBV()) {
            if (this.getChild(1).getValue() == -1L) {
                return "(bvneg " + this.getChild(0).smtEncodeBV(sMT) + ")";
            }
            return "(bvmul " + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")";
        }
        return null;
    }
}

