/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import savilerow.ASTNode;
import savilerow.BinOp;
import savilerow.CmdFlags;
import savilerow.Constants;
import savilerow.Divide;
import savilerow.Intpair;
import savilerow.NumberConstant;
import savilerow.Sat;
import savilerow.UnaryMinus;

public class SafeDivide
extends BinOp {
    public static final long serialVersionUID = 1L;

    public SafeDivide(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new SafeDivide(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 0L) {
            return NumberConstant.make(0L);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l;
            long l2 = this.getChild(0).getValue();
            if (l2 % (l = this.getChild(1).getValue()) != 0L && l < 0L) {
                CmdFlags.warning("Result of integer division is not an integer: " + this + ". Using floor(a/b) semantics.");
            }
            return NumberConstant.make(Divide.div(l2, l));
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            this.getChild(0).setParent(null);
            return this.getChild(0);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == -1L) {
            this.getChild(0).setParent(null);
            return new UnaryMinus(this.getChild(0));
        }
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 0L) {
            return NumberConstant.make(0L);
        }
        return null;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        ArrayList<Long> arrayList = new ArrayList<Long>(9);
        arrayList.add(0L);
        if (intpair2.lower != 0L) {
            arrayList.add(Divide.div(intpair.lower, intpair2.lower));
            arrayList.add(Divide.div(intpair.upper, intpair2.lower));
        }
        if (intpair2.upper != 0L) {
            arrayList.add(Divide.div(intpair.lower, intpair2.upper));
            arrayList.add(Divide.div(intpair.upper, intpair2.upper));
        }
        if (intpair2.lower <= -1L && intpair2.upper >= -1L) {
            arrayList.add(Divide.div(intpair.lower, -1L));
            arrayList.add(Divide.div(intpair.upper, -1L));
        }
        if (intpair2.lower <= 1L && intpair2.upper >= 1L) {
            arrayList.add(Divide.div(intpair.lower, 1L));
            arrayList.add(Divide.div(intpair.upper, 1L));
        }
        intpair.lower = (Long)Collections.min(arrayList);
        intpair.upper = (Long)Collections.max(arrayList);
        return intpair;
    }

    @Override
    public ArrayList<Intpair> getIntervalSetExp() {
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        if (Intpair.numValues(arrayList) * Intpair.numValues(arrayList2) > (long)Constants.intervallim) {
            return super.getIntervalSetExp();
        }
        ArrayList<Intpair> arrayList3 = new ArrayList<Intpair>();
        for (int i = 0; i < arrayList.size(); ++i) {
            for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                for (int k = 0; k < arrayList2.size(); ++k) {
                    for (long i2 = arrayList2.get((int)k).lower; i2 <= arrayList2.get((int)k).upper; ++i2) {
                        if (i2 == 0L) continue;
                        long l = Divide.div(j, i2);
                        arrayList3.add(new Intpair(l, l));
                    }
                }
            }
        }
        arrayList3.add(new Intpair(0L, 0L));
        Intpair.normalise(arrayList3);
        return arrayList3;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(BufferedWriter bufferedWriter, ASTNode aSTNode) throws IOException {
        bufferedWriter.append("div_undefzero(");
        this.getChild(0).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        this.getChild(1).toMinion(bufferedWriter, false);
        bufferedWriter.append(", ");
        aSTNode.toMinion(bufferedWriter, false);
        bufferedWriter.append(")");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "/" + this.getChild(1) + ")";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" div ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        if (l2 == 0L) {
            return l3 == 0L;
        }
        return Divide.div(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        return Divide.div(l, l2);
    }
}

